package com.zzsn.clb.fegin;

import org.jeecg.common.api.vo.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 常规feign接口定义
 */
@FeignClient(value = "service-project")
@Component
public interface IServiceProjectClient {

    /**
     * 根据专题类型id查询数据
     * @param  id
     * @return
     */
    Result<?> getListBySubjectType(@RequestParam(required = true) String id);

    /**
     * 根据专题id查询数据
     * @param  id
     * @return
     */
    Result<?> getSubjectById(@RequestParam(required = true) String id);

    /**
     * 根据信息id查询数据
     * @param  id
     * @return
     */
    Result<?> getListBySubject(@RequestParam(required = true) String id);
}
