package com.zzsn.clb.member.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.fegin.IServiceProjectClient;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import com.zzsn.clb.member.entity.MemThumbsUp;
import com.zzsn.clb.member.service.IMemThumbsUpService;
import java.util.Date;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

 /**
 * @Description: 会员点赞表
 * @Author: jeecg-boot
 * @Date:   2023-02-22
 * @Version: V1.0
 */
@Slf4j
@Api(tags="会员点赞表")
@RestController
@RequestMapping("/mach/mem/thumbsUp")
public class MemThumbsUpController extends JeecgController<MemThumbsUp, IMemThumbsUpService> {
	@Autowired
	private IMemThumbsUpService memThumbsUpService;

	 @Resource
	 IServiceProjectClient serviceProjectClient;
	/**
	 * 分页列表查询
	 *
	 * @param memThumbsUp
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	@AutoLog(value = "会员点赞表-分页列表查询")
	@ApiOperation(value="会员点赞表-分页列表查询", notes="会员点赞表-分页列表查询")
	@GetMapping(value = "/list")
	public Result<?> queryPageList(MemThumbsUp memThumbsUp,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<MemThumbsUp> queryWrapper = QueryGenerator.initQueryWrapper(memThumbsUp, req.getParameterMap());
		LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		queryWrapper.eq("user_id", user.getId());
		Page<MemThumbsUp> page = new Page<MemThumbsUp>(pageNo, pageSize);
		IPage<MemThumbsUp> pageList = memThumbsUpService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 * 添加
	 *
	 * @param memThumbsUp
	 * @return
	 */
	@AutoLog(value = "会员点赞表-添加")
	@ApiOperation(value="会员点赞表-添加", notes="会员点赞表-添加")
	@PostMapping(value = "/add")
	public Result<?> add(@RequestBody MemThumbsUp memThumbsUp) {
		if (StringUtils.isBlank(memThumbsUp.getArticleId())) {
			return Result.error("文章ID不能为空！");
		}
		LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		memThumbsUp.setUserId(user.getId());
		LambdaQueryWrapper<MemThumbsUp> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(MemThumbsUp::getUserId,memThumbsUp.getUserId()).eq(MemThumbsUp::getArticleId,memThumbsUp.getArticleId());
		if(this.memThumbsUpService.count(queryWrapper)>0)
		{
			memThumbsUpService.delete(queryWrapper,memThumbsUp);
			return Result.OK("取消成功！");
		}else {
			if(!this.serviceProjectClient.getInfoById(memThumbsUp.getArticleId()).isSuccess())
			{
				return Result.error("文章ID有误！");
			}
			memThumbsUpService.add(memThumbsUp);
			return Result.OK("点赞成功！");
		}
	}


	
	/**
	 * 通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "会员点赞表-通过id删除")
	@ApiOperation(value="会员点赞表-通过id删除", notes="会员点赞表-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<?> delete(@RequestParam(name="id",required=true) String id) {
		memThumbsUpService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 * 批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "会员点赞表-批量删除")
	@ApiOperation(value="会员点赞表-批量删除", notes="会员点赞表-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<?> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.memThumbsUpService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功！");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "会员点赞表-通过id查询")
	@ApiOperation(value="会员点赞表-通过id查询", notes="会员点赞表-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<?> queryById(@RequestParam(name="id",required=true) String id) {
		LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		MemThumbsUp memThumbsUp = new MemThumbsUp();
		memThumbsUp.setUserId(user.getId());
		LambdaQueryWrapper<MemThumbsUp> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(MemThumbsUp::getUserId,memThumbsUp.getUserId()).eq(MemThumbsUp::getArticleId,memThumbsUp.getArticleId());

		if(this.memThumbsUpService.count(queryWrapper)>0)
		{
			return Result.OK(memThumbsUp);
		}else
		{
			return Result.error("无此数据！");
		}
	}
}
