package com.zzsn.clb.member.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.entity.MemThumbsUp;
import com.zzsn.clb.member.mapper.MemThumbsUpMapper;
import com.zzsn.clb.member.service.IMemThumbsUpService;
import com.zzsn.clb.web.mapper.entity.SubjectDataExt;
import com.zzsn.clb.web.mapper.SubjectDataExtMapper;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @Description: 会员点赞表
 * @Author: jeecg-boot
 * @Date:   2023-02-22
 * @Version: V1.0
 */
@Service
public class MemThumbsUpServiceImpl extends ServiceImpl<MemThumbsUpMapper, MemThumbsUp> implements IMemThumbsUpService {
    @Resource
    SubjectDataExtMapper subjectDataExtMapper;

    @Override
    @Transactional
    public void delete(LambdaQueryWrapper<MemThumbsUp> queryWrapper, MemThumbsUp memThumbsUp) {
        this.baseMapper.delete(queryWrapper);
        subjectDataExtMapper.updateNum(memThumbsUp.getArticleId(), "thumbs_up_num", -1);
    }

    @Override
    @Transactional
    public void add(MemThumbsUp memThumbsUp) {
        this.baseMapper.insert(memThumbsUp);
        if(subjectDataExtMapper.selectById(memThumbsUp.getArticleId())==null)
        {
            SubjectDataExt subjectDataExt = new SubjectDataExt();
            subjectDataExt.setArticleId(memThumbsUp.getArticleId());
            subjectDataExt.setThumbsUpNum(0);
            subjectDataExt.setCollectNum(0);
            subjectDataExtMapper.insert(subjectDataExt);
        }
        subjectDataExtMapper.updateNum(memThumbsUp.getArticleId(), "thumbs_up_num", 1);
    }
}
