package com.zzsn.clb.member.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 专题表
 * @Author: jeecg-boot
 * @Date:   2021-12-15
 * @Version: V1.0
 */
@Data
@TableName("subject")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="subject对象", description="专题表")
public class Subject implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**专题编码*/
	@Excel(name = "专题编码", width = 15)
    @ApiModelProperty(value = "专题编码")
    private String subjectCode;
	/**专题名称*/
	@Excel(name = "专题名称", width = 15)
    @ApiModelProperty(value = "专题名称")
    private String subjectName;
	/**图片策略*/
	@Excel(name = "图片策略", width = 15, dicCode = "clb_save_policy")
	@Dict(dicCode = "clb_save_policy")
    @ApiModelProperty(value = "图片策略")
    private String picturePolicy;
	/**网页策略*/
	@Excel(name = "网页策略", width = 15, dicCode = "clb_save_policy")
	@Dict(dicCode = "clb_save_policy")
    @ApiModelProperty(value = "网页策略")
    private String pagePolicy;
	/**状态*/
	@Excel(name = "状态", width = 15, dicCode = "use_status")
	@Dict(dicCode = "use_status")
    @ApiModelProperty(value = "状态")
    private Integer status;
	/**启用时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@Excel(name = "启用时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "启用时间")
    private Date timeEnable;
	/**停用时间*/
    @TableField(updateStrategy = FieldStrategy.IGNORED)
	@Excel(name = "停用时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "停用时间")
    private Date timeDisable;
	/**划分专题库*/
	@Excel(name = "划分专题库", width = 15, dicCode = "Thematic_Library")
	@Dict(dicCode = "Thematic_Library")
    @ApiModelProperty(value = "划分专题库")
    private String library;
    /**定时单位(1分；2小时；3日；4月)*/
    @ApiModelProperty(value = "定时单位")
    private String unit;
    /**定时数值*/
    @ApiModelProperty(value = "定时数值")
    private Integer space;
    /**cron表达式*/
    @ApiModelProperty(value = "cron表达式")
    private String cron;
    /**是否提取热词*/
    @ApiModelProperty(value = "是否提取热词")
    private String ynExtractHotWords;
    /**事件专题增量分析规则*/
    @ApiModelProperty(value = "事件专题增量分析规则")
    private Integer increAnaRule;
    /**事件专题总量分析规则*/
    @ApiModelProperty(value = "事件专题总量分析规则")
    private Integer totalAnaRule;
    /**事件专题时间间隔分析规则(天)*/
    @ApiModelProperty(value = "事件专题时间间隔分析规则(天)")
    private Integer timeAnaRule;
    /**专题最近一次分析时间*/
    @ApiModelProperty(value = "专题最近一次分析时间")
    private Date analysisTime;
    /**外事办映射id*/
    @ApiModelProperty(value = "外事办映射id")
    private Integer wsbMapId;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;
	/**所属部门*/
    @ApiModelProperty(value = "所属部门")
    private String sysOrgCode;
    /**所属客户*/
    @ApiModelProperty(value = "所属客户")
    private String customerId;
    /**专题类别（1：通用专题  2：事件专题）*/
    private Integer subjectType;
}
