package com.zzsn.clb.web.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.entity.MemCollect;
import com.zzsn.clb.member.entity.MemThumbsUp;
import com.zzsn.clb.member.service.IMemCollectService;
import com.zzsn.clb.member.service.IMemThumbsUpService;
import org.apache.shiro.authc.AuthenticationException;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import com.zzsn.clb.web.mapper.entity.SubjectDataExt;
import com.zzsn.clb.web.service.ISubjectDataExtService;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.config.shiro.ShiroRealm;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: 文章扩展表
 * @Author: jeecg-boot
 * @Date: 2023-02-22
 * @Version: V1.0
 */
@Slf4j
@Api(tags = "文章扩展表")
@RestController
@RequestMapping("/mach/web")
public class SubjectDataExtController extends JeecgController<SubjectDataExt, ISubjectDataExtService> {
    @Autowired
    private ISubjectDataExtService subjectDataExtService;
    @Autowired
    private IMemThumbsUpService memThumbsUpService;
    @Autowired
    private IMemCollectService memCollectService;
    @Resource
    private ShiroRealm shiroRealm;

    /**
     * 通过id查询
     *
     * @param articleId
     * @return
     */
    @AutoLog(value = "文章扩展表-通过id查询")
    @ApiOperation(value = "文章扩展表-通过id查询", notes = "文章扩展表-通过id查询")
    @GetMapping(value = "/queryArticleById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String articleId, HttpServletRequest request) {
        SubjectDataExt subjectDataExt = subjectDataExtService.getById(articleId);
        if(subjectDataExt==null)
        {
            subjectDataExt=new SubjectDataExt();
            subjectDataExt.setArticleId(articleId);
            subjectDataExt.setCollectNum(0);
            subjectDataExt.setThumbsUpNum(0);
        }
        LoginUser user = null;
        try {
            user = shiroRealm.checkUserTokenIsEffect(request.getHeader("X-Access-Token"));
        } catch (Exception ex) {

        }
        if (user != null) {
            LambdaQueryWrapper<MemThumbsUp> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(MemThumbsUp::getUserId, user.getId()).eq(MemThumbsUp::getArticleId, articleId);
            subjectDataExt.setThumbsStatus(memThumbsUpService.count(queryWrapper) > 0 ? true : false);
            LambdaQueryWrapper<MemCollect> queryWrapperCollect = new LambdaQueryWrapper<>();
            queryWrapperCollect.eq(MemCollect::getUserId, user.getId()).eq(MemCollect::getArticleId, articleId);
            subjectDataExt.setCollectStatus(memCollectService.count(queryWrapperCollect) > 0 ? true : false);
        }else
        {
            subjectDataExt.setThumbsStatus(false);
            subjectDataExt.setCollectStatus(false);
        }
        return Result.OK(subjectDataExt);
    }


}
