package com.zzsn.clb.web.mapper.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 文章扩展表
 * @Author: jeecg-boot
 * @Date:   2023-02-22
 * @Version: V1.0
 */
@Data
@TableName("subject_data_ext")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="subject_data_ext对象", description="文章扩展表")
public class SubjectDataExt {
    
	/**文章ID*/
	@TableId(type = IdType.INPUT)
    @ApiModelProperty(value = "文章ID")
	private String articleId;
	/**收藏数量*/
	@Excel(name = "收藏数量", width = 15)
    @ApiModelProperty(value = "收藏数量")
	@JsonIgnore
	private Integer collectNum;
	/**点赞数量*/
	@Excel(name = "点赞数量", width = 15)
    @ApiModelProperty(value = "点赞数量")
	private Integer thumbsUpNum;

	/**收藏状态*/
	@ApiModelProperty(value = "收藏状态")
	@TableField(exist = false)
	private Boolean collectStatus;
	/**点赞状态*/
	@ApiModelProperty(value = "点赞状态")
	@TableField(exist = false)
	private Boolean thumbsStatus;
}
