package com.zzsn.clb.member.controller;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.fegin.IServiceProjectClient;
import com.zzsn.clb.member.entity.MemThumbsUp;
import com.zzsn.clb.member.service.ISubjectTreeService;
import com.zzsn.clb.web.service.ISubjectService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import com.zzsn.clb.member.entity.MemCollect;
import com.zzsn.clb.member.service.IMemCollectService;

import java.util.Date;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import com.alibaba.fastjson.JSON;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: 会员收藏表
 * @Author: jeecg-boot
 * @Date: 2023-02-22
 * @Version: V1.0
 */
@Slf4j
@Api(tags = "会员收藏表")
@RestController
@RequestMapping("/mach/mem/collect")
public class MemCollectController extends JeecgController<MemCollect, IMemCollectService> {
    @Autowired
    private IMemCollectService memCollectService;

    @Resource
    IServiceProjectClient serviceProjectClient;

    @Resource
    ISubjectTreeService subjectTreeService;
    /**
     * 分页列表查询
     *
     * @param memCollect
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "会员收藏表-分页列表查询")
    @ApiOperation(value = "会员收藏表-分页列表查询", notes = "会员收藏表-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(MemCollect memCollect,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {
        QueryWrapper<MemCollect> queryWrapper = QueryGenerator.initQueryWrapper(memCollect, req.getParameterMap());
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq("user_id", user.getId());
        Page<MemCollect> page = new Page<MemCollect>(pageNo, pageSize);
        IPage<MemCollect> pageList = memCollectService.page(page, queryWrapper);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param memCollect
     * @return
     */
    @AutoLog(value = "会员收藏表-添加")
    @ApiOperation(value = "会员收藏表-添加", notes = "会员收藏表-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody MemCollect memCollect) {
        if (StringUtils.isBlank(memCollect.getArticleId())) {
            return Result.error("文章ID不能为空！");
        }

        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        memCollect.setUserId(user.getId());
        LambdaQueryWrapper<MemCollect> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MemCollect::getUserId, memCollect.getUserId()).eq(MemCollect::getArticleId, memCollect.getArticleId());
        if (this.memCollectService.count(queryWrapper) > 0) {
            memCollectService.delete(queryWrapper, memCollect);
            return Result.OK("取消成功！");
        } else {
            Result<JSONObject> result =this.serviceProjectClient.getInfoById(memCollect.getArticleId());
            if(!result.isSuccess())
            {
                return Result.error("文章ID有误！");
            }
            memCollect.setTitle(result.getResult().getString("title"));
            memCollect.setPublishDate(result.getResult().getDate("publishDate"));
            memCollect.setOrigin(result.getResult().getString("origin"));
            memCollect.setSubjectId(result.getResult().getString("subjectId"));
            memCollect.setSubjectName(subjectTreeService.getById(memCollect.getSubjectId()).getSubjectName());
            memCollectService.add(memCollect);
            return Result.OK("收藏成功！");
        }

    }


    /**
     * 通过id删除
     *
     * @param articleId 文章ID
     * @return
     */
    @AutoLog(value = "会员收藏表-通过id删除")
    @ApiOperation(value = "会员收藏表-通过id删除", notes = "会员收藏表-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "articleId", required = true) String articleId) {
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        MemCollect memCollect = new MemCollect();
        memCollect.setUserId(user.getId());
        memCollect.setArticleId(articleId);
        LambdaQueryWrapper<MemCollect> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MemCollect::getUserId, memCollect.getUserId()).eq(MemCollect::getArticleId, memCollect.getArticleId());
        memCollectService.remove(queryWrapper);
        return Result.OK("删除成功!");
    }
}
