package com.zzsn.clb.fegin;

import com.alibaba.fastjson.JSONObject;
import org.jeecg.common.api.vo.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 常规feign接口定义
 */
@FeignClient(value = "service-project")
@Component
public interface IServiceProjectClient {

    /***
     * 根据专题类型id查询数据
     *
     * @param map
     * @param userId
     * @param video
     * @param pageNo 当前页码
     * @param pageSize 每页显示多少条
     * @param column 排序字段
     * @param order 排序升序asc，降序desc
     * @param crawler
     * @param isSubject 是否专题 0-否 1-是
     * @param subjectType     专题类别（1：通用专题  2：事件专题）
     * @return
     */
    @GetMapping(value = "/subject/display/list")
    Result<?> getListBySubject(@RequestParam Map<String, Object> map, @RequestParam String userId,@RequestParam String video,@RequestParam Integer pageNo,@RequestParam Integer pageSize,@RequestParam String column,@RequestParam String order,@RequestParam String crawler,@RequestParam String isSubject,@RequestParam String subjectType,@RequestParam String labelIds);

    /**
     * 根据信息id查询数据
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/subject/display/queryById")
    Result<JSONObject> getInfoById(@RequestParam(required = true) String id);


    /***
     * 查询专题数据
     * @param jsonObject 查询条件
     * @param pageNo 页码
     * @param pageSize 每页显示条数
     * @return
     */
    @GetMapping(value = "/subject/subject/list")
    Result<JSONObject> getSubjectList(@RequestParam(required = true) JSONObject jsonObject,@RequestParam(required = false) Integer pageNo,@RequestParam(required = false) Integer pageSize);
}
