
import os.path
import random

from openpyxl import Workbook, load_workbook

from base.BaseCore import BaseCore
baseCore = BaseCore()
log = baseCore.getLogger()
cnx = baseCore.cnx
cursor = baseCore.cursor

class File():
    # 创建文件
    def createFile(self,file_name):
        if os.path.exists(file_name):
            return
        else:
            wb = Workbook()
            sheet = wb.active
            # 更改默认的sheet名称
            sheet.title = "需处理企业"
            sheet.append(["企业名称", "社会信用代码"])
            # 创建另一个sheet
            sheet2 = wb.create_sheet("获取基本信息成功企业")
            sheet2.append(["企业名称", "采到的企业名称", "社会信用代码", "采到的信用代码"])
            wb.save(file_name)
            wb.close()

    # 删除文件
    def deleteFile(self,file_name):
        if os.path.exists(file_name):
            os.remove(file_name)
        else:
            pass

    # 追加数据
    def appenddata(self,file_name, sheet, data):
        # 打开现有的Excel文件
        wb = load_workbook(file_name)

        # 选择要追加数据的sheet
        sheet = wb[sheet]
        sheet.append(data)
        # 保存Excel文件
        wb.save(file_name)
        wb.close()

class Token():
    # 获取token
    def getToken(self):
        # cursor.execute(f"select id,cookies from QCC_token  where fenghao_time < DATE_SUB(NOW(), INTERVAL 2 HOUR) order by update_time asc limit 1")
        cursor.execute(f" select id, cookies from QCC_token where id= 82 ")
        # rows = cursor.fetchall()
        # cnx.commit()
        # if rows:
        #     try:
        #         token_info = rows[random.randint(0, len(rows) - 1)]
        #         token = token_info[1]
        #         id = token_info[0]
        #         return token, id
        #     except:
        #         return False, False
        # else:
        #     # 没有查到token
        #     log.info("没有拿到token")
        #     return False, False

        row = cursor.fetchall()
        cnx.commit()
        if row:
            pass
        else:
            # 没有查到token
            log.info("没有拿到token")
            return False

        return row[0]

    # 删除失效的token
    def delete_token(self, cookie_):
        deletesql = f"delete from QCC_token where id='{cookie_}' "
        cursor.execute(deletesql)
        cnx.commit()

    # token的处理
    def updateTokeen(self,id_token, type):
        if type == 1:
            # session失效，删除token
            cursor.execute(f"delete from QCC_token where id={id_token}")
        if type == 2:
            # 封号了  修改封号时间
            cursor.execute(f"update QCC_token set fenghao_time=now()   where id={id_token}")
        if type == 3:
            # 修改使用时间
            cursor.execute(f"update QCC_token set update_time=now()   where id={id_token}")
        cnx.commit()

class Tag():
    # 删除特定属性标签
    def deletep(self, soup, tag_, attribute_to_delete, value_to_delete):
        if attribute_to_delete and value_to_delete:
            # 查找带有指定属性的P标签并删除
            tags = soup.find_all(tag_, {attribute_to_delete: value_to_delete})
            for tag in tags:
                # print(tag)
                tag.decompose()
        else:
            tags = soup.find_all(tag_)
            for tag in tags:
                # print(tag)
                tag.decompose()

    # 删除空标签
    def deletek(self, soup):
        # 删除空白标签（例如<p></p>、<p><br></p>, img、video、hr除外）
        for i in soup.find_all(lambda tag: len(tag.get_text()) == 0 and tag.name not in ["img", "video",
                                                                                         "br"] and tag.name != "br" or tag.get_text() == ' ' or tag.get_text() == ' '):
            for j in i.descendants:
                if j.name in ["img", "video", "br"]:
                    break
            else:
                i.decompose()

    # 删除span标签
    def deletespan(self, td):
        spans = td.find_all('span', class_='app-copy copy-button-item')
        for span in spans:
            if '复制' in span.text:
                span.extract()  # 删除span标签

        spans2 = td.find_all('span', slot='content')
        for span2 in spans2:
            if '趋势图' in span2.text:
                span2.extract()
        spans3 = td.find_all('span', class_='m-l-r-10')
        for span3 in spans3:
            if '年报' in span3.text:
                span3.extract()
        spans4 = td.find_all('span', class_='text-span')
        for span4 in spans4:
            span4.extract()