import datetime
import json
import re
import time

import requests
from bs4 import BeautifulSoup
from kafka import KafkaProducer
from retry import retry
from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By

from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
URL = 'http://www.ccgp.gov.cn/'


def sendKafka(dic_news):
    try:
        producer = KafkaProducer(bootstrap_servers=['114.115.159.144:9092'])
        kafka_result = producer.send("tenderClusterData",
                                     json.dumps(dic_news, ensure_ascii=False).encode('utf8'))

        print(kafka_result.get(timeout=10))

        log.info(f"{dic_news['title']}.....{dic_news['subtitle']}.....{dic_news['sourceAddress']}传输成功")
    except Exception as e:
        log.error(f'{e}')
        log.error(f"{dic_news['title']}.....{dic_news['subtitle']}.....{dic_news['sourceAddress']}传输失败")


# 招标结构化信息
def getDataA(session, title, publishDate, province, href):
    fj_list = []
    city = ''
    contentNo = ''
    biddingProjectName = ''
    biddingItems = ''
    biddingUnit = ''
    biddingUnitAddress = ''
    bidOpeningTime = ''
    bidOpeningAddress = ''
    budgetAmount = ''
    biddingContact = ''
    biddingPhone = ''
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    biddingContent = ''
    no_flg = 1
    soup = BeautifulSoup(req.text, 'lxml')
    div = soup.find('div', class_='table')
    tr_list = div.select('tr')
    for tr in tr_list:
        if '采购项目名称' in tr.text:
            biddingProjectName = tr.find_all('td')[-1].text
        elif '品目' in tr.text:
            biddingItems = tr.find_all('td')[-1].text
        elif '采购单位地址' in tr.text:
            biddingUnitAddress = tr.find_all('td')[-1].text
        elif '采购单位' in tr.text and '采购单位联系方式' not in tr.text:
            biddingUnit = tr.find_all('td')[-1].text
        elif '开标时间' in tr.text:
            bidOpeningTime = tr.find_all('td')[-1].text.replace('年', '-').replace('月', '-').split('日')[0]
        elif '开标地点' in tr.text:
            bidOpeningAddress = tr.find_all('td')[-1].text
        elif '预算金额' in tr.text:
            budgetAmount = tr.find_all('td')[-1].text
        elif '项目联系人' in tr.text:
            biddingContact = tr.find_all('td')[-1].text
        elif '采购单位联系方式' in tr.text:
            biddingPhone = tr.find_all('td')[-1].text
        elif '行政区域' in tr.text:
            city = tr.find_all('td')[1].text
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    table = contentWithTag.find('table', class_='Content')
    if table:
        tr_list = table.find_all('tr')
        for i in range(len(tr_list)):
            if '项目编号：' in tr_list[i].text:
                try:
                    if no_flg == 1:
                        contentNo = tr_list[i].text.lstrip().strip()
                        no_flg = 0
                except:
                    contentNo = ''
            elif '采购需求' in tr_list[i].text:
                try:
                    try:
                        biddingContent = tr_list[i].text.split('采购需求：')[1].lstrip().strip()
                    except:
                        biddingContent = tr_list[i + 1].text.lstrip().strip()
                except:
                    biddingContent = ''
    else:
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):
            if '采购需求：' in p_list[i].text:
                try:
                    biddingContent = p_list[i + 1].text
                except:
                    biddingContent = ''
            elif '项目编号：' in p_list[i].text:
                try:
                    if no_flg == 1:
                        try:
                            contentNo = p_list[i].text.split('项目编号：')[1].split('项目名称')[0].lstrip().strip().split(' ')[0]
                        except:
                            try:
                                contentNo = \
                                    p_list[i].text.split('项目编号：')[1].split('项目名称')[0].lstrip().strip().split(' ')[0]
                            except:
                                contentNo = \
                                    p_list[i].text.split('项目编号）：')[1].split('采购项目名称')[0].lstrip().strip().split(' ')[0]
                        no_flg = 0
                except:
                    contentNo = ''
            elif '采购项目编号' in p_list[i].text:
                try:
                    if no_flg == 1:
                        contentNo = \
                            p_list[i].text.split('采购项目编号（建议书编号）：')[1].split('采购项目名称')[0].lstrip().strip().split(' ')[0]
                        no_flg = 0
                except:
                    contentNo = ''
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '招标公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': city,  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': contentNo,  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': biddingProjectName,  # 招标项目名称
        'biddingItems': biddingItems,  # 品目
        'biddingUnit': biddingUnit,  # 招标单位
        'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
        'bidOpeningTime': bidOpeningTime,  # 开标时间
        'bidOpeningAddress': bidOpeningAddress,  # 开标地点
        'budgetAmount': budgetAmount,  # 预算金额
        'biddingContact': biddingContact,  # 招标单位联系人
        'biddingPhone': biddingPhone,  # 招标单位联系电话
        'biddingContent': biddingContent,  # 招标内容
        'winningBidder': '',  # 中标单位
        'winningBidderAddress': '',  # 中标单位地址
        'bidPrice': '',  # 中标价格
    }
    return data


def getDataA_(session, title, publishDate, province, href):
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'lxml')
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '招标公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': '',  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': '',  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': '',  # 招标项目名称
        'biddingItems': '',  # 品目
        'biddingUnit': '',  # 招标单位
        'biddingUnitAddress': '',  # 招标单位地址
        'bidOpeningTime': '',  # 开标时间
        'bidOpeningAddress': '',  # 开标地点
        'budgetAmount': '',  # 预算金额
        'biddingContact': '',  # 招标单位联系人
        'biddingPhone': '',  # 招标单位联系电话
        'biddingContent': '',  # 招标内容
        'winningBidder': '',  # 中标单位
        'winningBidderAddress': '',  # 中标单位地址
        'bidPrice': '',  # 中标价格
    }
    return data


# 中标结构化信息
def getDataB(session, title, publishDate, province, href):
    fj_list = []
    city = ''
    contentNo = ''
    biddingProjectName = ''
    biddingItems = ''
    biddingUnit = ''
    biddingUnitAddress = ''
    biddingContact = ''
    biddingPhone = ''
    bidPrice = ''
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    biddingContent = ''
    no_flg = 1
    soup = BeautifulSoup(req.text, 'lxml')
    div = soup.find('div', class_='table')
    tr_list = div.select('tr')
    for tr in tr_list:
        if '采购项目名称' in tr.text:
            biddingProjectName = tr.find_all('td')[-1].text
        elif '品目' in tr.text:
            biddingItems = tr.find_all('td')[-1].text
        elif '采购单位地址' in tr.text:
            biddingUnitAddress = tr.find_all('td')[-1].text
        elif '采购单位' in tr.text and '采购单位联系方式' not in tr.text:
            biddingUnit = tr.find_all('td')[-1].text
        elif '项目联系人' in tr.text:
            biddingContact = tr.find_all('td')[-1].text
        elif '采购单位联系方式' in tr.text:
            biddingPhone = tr.find_all('td')[-1].text
        elif '行政区域' in tr.text:
            city = tr.find_all('td')[1].text
        elif '总中标金额' in tr.text:
            bidPrice = tr.find_all('td')[-1].text
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    p_list = contentWithTag.find_all('p')
    for i in range(len(p_list)):
        if '采购需求：' in p_list[i].text:
            try:
                biddingContent = p_list[i + 1].text
            except:
                biddingContent = ''
    try:
        try:
            contentNo = re.findall('项目编号：(.*)（招标文件编号', content)[0].lstrip().strip()
        except:
            contentNo = re.findall('项目编号：(.*)二、项目名称', content)[0].lstrip().strip()
    except:
        p_list = contentWithTag.find_all('p')
        for i in range(len(p_list)):
            if '一、项目编号' in p_list[i].text:
                contentNo = p_list[i + 1].text.lstrip().strip()
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '中标公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': city,  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': contentNo,  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': biddingProjectName,  # 招标项目名称
        'biddingItems': biddingItems,  # 品目
        'biddingUnit': biddingUnit,  # 招标单位
        'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
        'bidOpeningTime': '',  # 开标时间
        'bidOpeningAddress': '',  # 开标地点
        'budgetAmount': '',  # 预算金额
        'biddingContact': biddingContact,  # 招标单位联系人
        'biddingPhone': biddingPhone,  # 招标单位联系电话
        'biddingContent': biddingContent,  # 招标内容
        'winningBidder': '',  # 中标单位
        'winningBidderAddress': '',  # 中标单位地址
        'bidPrice': bidPrice,  # 中标价格
    }
    return data


def getDataB_(session, title, publishDate, province, href):
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'lxml')
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '中标公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': '',  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': '',  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': '',  # 招标项目名称
        'biddingItems': '',  # 品目
        'biddingUnit': '',  # 招标单位
        'biddingUnitAddress': '',  # 招标单位地址
        'bidOpeningTime': '',  # 开标时间
        'bidOpeningAddress': '',  # 开标地点
        'budgetAmount': '',  # 预算金额
        'biddingContact': '',  # 招标单位联系人
        'biddingPhone': '',  # 招标单位联系电话
        'biddingContent': '',  # 招标内容
        'winningBidder': '',  # 中标单位
        'winningBidderAddress': '',  # 中标单位地址
        'bidPrice': '',  # 中标价格
    }
    req.close()
    return data


# 成交结构化信息
def getDataC(session, title, publishDate, province, href):
    fj_list = []
    city = ''
    contentNo = ''
    biddingProjectName = ''
    biddingItems = ''
    biddingUnit = ''
    biddingUnitAddress = ''
    biddingContact = ''
    biddingPhone = ''
    winningBidder = ''
    winningBidderAddress = ''
    bidPrice = ''
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    biddingContent = ''
    no_flg = 1
    soup = BeautifulSoup(req.text, 'lxml')
    div = soup.find('div', class_='table')
    tr_list = div.select('tr')
    for tr in tr_list:
        if '采购项目名称' in tr.text:
            biddingProjectName = tr.find_all('td')[-1].text
        elif '品目' in tr.text:
            biddingItems = tr.find_all('td')[-1].text
        elif '采购单位地址' in tr.text:
            biddingUnitAddress = tr.find_all('td')[-1].text
        elif '采购单位' in tr.text and '采购单位联系方式' not in tr.text:
            biddingUnit = tr.find_all('td')[-1].text
        elif '项目联系人' in tr.text:
            biddingContact = tr.find_all('td')[-1].text
        elif '采购单位联系方式' in tr.text:
            biddingPhone = tr.find_all('td')[-1].text
        elif '行政区域' in tr.text:
            city = tr.find_all('td')[1].text
        elif '总中标金额' in tr.text or '总成交金额' in tr.text:
            bidPrice = tr.find_all('td')[-1].text
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    p_list = contentWithTag.find_all('p')
    for i in range(len(p_list)):
        if '一、项目编号' in p_list[i].text:
            try:
                contentNo = p_list[i].text.split('一、项目编号：')[1].split('（招标文件编号')[0].lstrip().strip()
            except:
                contentNo = ''
        elif '中标（成交）信息' in p_list[i].text:
            try:
                winningBidder = p_list[i + 1].text.lstrip().strip()
                winningBidderAddress = p_list[i + 2].text.lstrip().strip()
            except:
                winningBidder = ''
                winningBidderAddress = ''
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '成交公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': city,  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': contentNo,  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': biddingProjectName,  # 招标项目名称
        'biddingItems': biddingItems,  # 品目
        'biddingUnit': biddingUnit,  # 招标单位
        'biddingUnitAddress': biddingUnitAddress,  # 招标单位地址
        'bidOpeningTime': '',  # 开标时间
        'bidOpeningAddress': '',  # 开标地点
        'budgetAmount': '',  # 预算金额
        'biddingContact': biddingContact,  # 招标单位联系人
        'biddingPhone': biddingPhone,  # 招标单位联系电话
        'biddingContent': biddingContent,  # 招标内容
        'winningBidder': winningBidder,  # 中标单位
        'winningBidderAddress': winningBidderAddress,  # 中标单位地址
        'bidPrice': bidPrice,  # 中标价格
    }
    req.close()
    return data


def getDataC_(session, title, publishDate, province, href):
    req = session.get(href)
    if req.status_code == 404:
        log.error(f'{href}===404')
        return
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'lxml')
    contentWithTag = soup.find('div', class_='vF_detail_content_container')
    content = contentWithTag.text
    if content == 0:
        log.error(f'{href}===解析失败')
        return
    a_list = contentWithTag.find_all('a')
    contentWithTag = str(contentWithTag)
    for a in a_list:
        try:
            href = a.get('href')
            contentWithTag.replace(href, f'http{href}')
        except:
            pass
    data = {
        'businessType': '政府采购',  # 业务类型
        'infoType': '成交公告',  # 信息类型
        'trade': '',  # 行业
        'province': province,  # 省份
        'city': '',  # 市区
        'origin': '中国政府采购网',  # 来源网站
        'isAbroad': '1',  # 1、国内 2、国外
        'contentNo': '',  # 编号
        'content': content,  # 内容(不带标签)
        'contentWithTag': str(contentWithTag),  # 内容(带标签)
        'sid': '1699606095238131714',  # 信息源id
        'publishDate': publishDate,  # 发布时间
        'sourceAddress': href,  # 原文链接
        'title': title,  # 标题
        'subtitle': '',  # 二级标题
        'biddingProjectName': '',  # 招标项目名称
        'biddingItems': '',  # 品目
        'biddingUnit': '',  # 招标单位
        'biddingUnitAddress': '',  # 招标单位地址
        'bidOpeningTime': '',  # 开标时间
        'bidOpeningAddress': '',  # 开标地点
        'budgetAmount': '',  # 预算金额
        'biddingContact': '',  # 招标单位联系人
        'biddingPhone': '',  # 招标单位联系电话
        'biddingContent': '',  # 招标内容
        'winningBidder': '',  # 中标单位
        'winningBidderAddress': '',  # 中标单位地址
        'bidPrice': '',  # 中标价格
    }
    req.close()
    return data


# 获取总页数
@retry(tries=3, delay=10)
def getTotal(url):
    session_total = requests.session()
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36 Edg/118.0.2088.57',
        'Upgrade-Insecure-Requests': '1',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'Accept-Encoding': 'gzip, deflate',
        'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
        'Cache-Control': 'no-cache',
        'Connection': 'keep-alive',
    }
    ip = baseCore.get_proxy()
    session_total.get(URL, headers=headers, proxies=ip, timeout=20)
    # req = requests.get(url, headers=headers, proxies=ip)
    req = session_total.get(url)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'html.parser')
    p = soup.find('p', class_='pager').find('script').text
    totle = re.findall(r'size:(.*?),', p)[0]
    session_total.close()
    return int(totle)


# 获取soup
@retry(tries=3, delay=10)
def getSoup(url):
    session_soup = requests.session()
    headers = {
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36 Edg/118.0.2088.57',
        'Upgrade-Insecure-Requests': '1',
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'Accept-Encoding': 'gzip, deflate',
        'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
        'Cache-Control': 'no-cache',
        'Connection': 'keep-alive',
    }
    ip = baseCore.get_proxy()
    session_soup.get(URL, headers=headers, proxies=ip, timeout=20)
    # req = requests.get(url, headers=headers, proxies=ip)
    req = session_soup.get(url)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'html.parser')
    session_soup.close()
    return soup


def doJob():
    headers = {}
    headers['user-agent'] = baseCore.getRandomUserAgent()
    session = requests.session()
    session.get(URL, headers=headers)
    # start_time = ((datetime.date.today() - datetime.timedelta(days=2)).strftime("%Y:%m:%d"))
    start_time = '2023:10:01'
    end_time = datetime.datetime.now().strftime('%Y:%m:%d')
    bidTypes = [[11, '成交公告'], [1, '公开招标'], [7, '中标公告']]
    for bidType in bidTypes:
        num = 0
        url = f'http://search.ccgp.gov.cn/bxsearch?searchtype=1&page_index=1&bidSort=0&buyerName=&projectId=&pinMu=0&bidType={bidType[0]}&dbselect=bidx&kw=&start_time={start_time}&end_time={end_time}&timeType=6&displayZone=&zoneId=&pppStatus=0&agentName='
        try:
            total = getTotal(url)
        except:
            log.error(f'{bidType[1]}===获取总页数失败')
            continue
        log.info(f'开始采集{bidType[1]}===共{total}页')
        time.sleep(1.5)
        for page in range(1, int(total) + 1):
            log.info(f'正在采集==={bidType[1]}===第{page}页')
            url = f'http://search.ccgp.gov.cn/bxsearch?searchtype=1&page_index={page}&bidSort=0&buyerName=&projectId=&pinMu=0&bidType={bidType[0]}&dbselect=bidx&kw=&start_time={start_time}&end_time={end_time}&timeType=6&displayZone=&zoneId=&pppStatus=0&agentName='
            try:
                soup = getSoup(url)
            except:
                log.error(f'{bidType[1]}===第{page}页===解析失败')
                continue
            try:
                li_list = soup.find('ul', class_='vT-srch-result-list-bid').find_all('li')
            except:
                log.error(f'{bidType[1]}===第{page}页===获取信息列表失败')
                continue
            for li in li_list:
                a = li.find('a')
                href = a.get('href')
                title = a.text.lstrip().strip()
                pub_time = li.find('span').text.split(' ')[0].replace('.',
                                                                      '-').lstrip().strip()
                province = li.find('span').find('a').text
                if bidType[0] == 1:
                    try:
                        data = getDataA(session, title, pub_time, province, href)
                    except:
                        data = getDataA_(session, title, pub_time, province, href)
                elif bidType[0] == 7:
                    try:
                        data = getDataB(session, title, pub_time, province, href)
                    except:
                        data = getDataB_(session, title, pub_time, province, href)
                else:
                    try:
                        data = getDataC(session, title, pub_time, province, href)
                    except:
                        data = getDataC_(session, title, pub_time, province, href)
                if data:
                    print(data['title'])
                    # sendKafka(data)
                    num += 1
                time.sleep(1.5)
        log.info(f'{bidType[1]}===采集{num}条')
    session.close()


if __name__ == '__main__':
    # while True:
    doJob()
    # current_time = datetime.datetime.now()
    # midnight_time = current_time.replace(hour=0, minute=0, second=0, microsecond=0) + datetime.timedelta(days=1)
    # sleep_seconds = (midnight_time - current_time).total_seconds()
    # time.sleep(sleep_seconds)
    baseCore.close()
