from elasticsearch import Elasticsearch

# 连接ES
es=Elasticsearch(["192.168.1.90:9200"],
                 sniff_on_start=True,# 连接前测试
                 sniff_on_connection_fail=True,# 节点无响应时刷新节点
                 sniffer_timeout=60) # 设置超时时间
index_name='test_data'
def main():
    # 连接ES
    es=Elasticsearch(["192.168.1.90:9200"],
                     sniff_on_start=True,# 连接前测试
                     sniff_on_connection_fail=True,# 节点无响应时刷新节点
                     sniffer_timeout=60) # 设置超时时间

if __name__ == '__main__':
    main()

# 创建索引
def create_index():
    # 定义mapping body
    body_index = {
        'mappings': {
            'properties': {
                'name': {
                    'type': 'keyword'
                },
                'age': {
                    'type': 'long'
                },
                'tags': {
                    'type': 'text'
                }
            }
        },
        'settings': {
            'index': {
                'number_of_shards': '3',
                'number_of_replicas': '0'
            }
        }
    }
    # 创建index
    res = es.indices.create(index=index_name, body=body_index, ignore=400)

def instert_data():
    person1 = {
        'name': '张三',
        'age': 18,
        'tags': '勤奋学习十载寒窗，凿壁借光，囊萤映雪，手不释卷，有良好的表达能力。有耐心心态好，善于维系客户关系。果断热情勇敢孤僻活力，思想成熟能够独立工作。'
    }
    res = es.index(index=index_name, body=person1)

from elasticsearch import helpers
def instert_bach():
    insert_infos = []
    person2 = {
        '_index': index_name,
        'name': '李四',
        'age': 20,
        'tags': '有极强的领导艺术，公正严明铁面无私，公私分明。关心他人无微不至，体贴入微。精力充沛，并有很强的事业心。气吞山河正气凛然，善于同各种人员打交道。'
    }
    person3 = {
        '_index': index_name,
        'name': '王五',
        'age': 19,
        'tags': '尊敬师长团结同学，乐于助人学习勤奋，用心向上，用心参加班级学校组织的各种课内外活动。用心开展批评与自我批评。'
    }
    insert_infos.append(person2)
    insert_infos.append(person3)
    helpers.bulk(client=es, actions=insert_infos)

def del_index():
    # 删除index
    res = es.indices.delete(index=index_name, ignore=[400])

def del_doc_byid():
    # 按id删除
    res = es.delete(index=index_name, id='bKTgXYUBfH4USN9RFMOh')

def del_by_condation():
    # 按条件删除
    body = {
        'query': {
            'match': {
                'name': '张三'
            }
        }
    }
    res = es.delete_by_query(index=index_name, body=body, ignore=[400, 404])

# index() 方法完成两个操作，如果数据不存在，那就执行插入操作，如果已经存在，那就执行更新操作。
# index实现更新时，body中必须写入全部字段，否则未包含的字段会被置为空。
def index_update_doc():
    body = {
        'name': '王五',
        'age': 19,
        'tags': '尊敬师长团结同学，乐于助人学习勤奋，用心向上，用心参加班级学校组织的各种课内外活动。用心开展批评与自我批评。'
    }
    res = es.index(index=index_name, id='baTgXYUBfH4USN9RFMOh', body=body)

def update_doc():
    body = {
        'doc': {
            'name': '王五'
        }
    }
    es.update(index=index_name, id='baTgXYUBfH4USN9RFMOh', body=body)

def select_info():
    # 查看ES中索引的信息
    index_info = es.indices.get('*')
    # 查看索引的名称
    index_names = index_info.keys()

    index_name = 'es_index'
    print(es.indices.exists(index_name))
    doc_count = es.count(index=index_name)

def query_by_id():
    body = {
        'query': {
            'match': {
                '_id': 'baTgXYUBfH4USN9RFMOh'
            }
        }
    }
    res = es.search(index=index_name, body=body)

def query_by_filed():
    body = {
        'query': {
            'match': {
                'age': 20
            }
        },
        '_source': ['name', 'tags']
    }
    res = es.search(index=index_name, body=body)

def query_by_sort():
    body = {
        'sort': {
            'age': {
                'order': 'desc' # asc: 升序, desc: 降序
            }
        }
    }
    res = es.search(index=index_name, body=body)

def query_by_range():
    body = {
        'query': {
            'range': {
                'age': {
                    'gt': 18,
                    'lte': 20
                }
            }
        }
    }
    res = es.search(index=index_name, body=body)

def query_by_page():
    body = {
        'sort': {
            'age': {
                'order': 'desc' # asc: 升序, desc: 降序
            }
        },
        'from': 0,
        'size': 1
    }
    res = es.search(index=index_name, body=body)

def quere_by_paser():
    body = {
        "query": {
            "match_phrase": {
                "tags": "耐心"
            }
        }
    }
    res = es.search(index=index_name, body=body)

def query_by_mult():
    body = {
        "query": {
            "bool": {
                "must": [
                    {
                        "match": {
                            "name": "张三"
                        }
                    },
                    {
                        "match_phrase": {
                            "tags": "耐心"
                        }
                    }
                ]
            }
        }
    }
    res = es.search(index=index_name, body=body)

def query_by_not():
    body = {
        "query": {
            "bool": {
                "must": [
                    {
                        "match": {
                            "name": "王五"
                        }
                    }
                ],
                'must_not': [
                    {
                        "match_phrase": {
                            "tags": "耐心"
                        }
                    }
                ]
            }
        }
    }
    res = es.search(index=index_name, body=body)










