import json
import os
import time

import numpy as np
import pandas as pd
import requests
from bs4 import BeautifulSoup
from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
headers = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
    'Content-Type': 'application/json',
}


def getSoup(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    soup = BeautifulSoup(req.text, 'html.parser')
    return soup


def getFjContent(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    return req.content


def getTotal():
    ip = baseCore.get_proxy()
    url = 'http://www.gxzf.gov.cn/irs/front/search'
    data_post = {"code": "181aedaa542", "dataTypeId": "241", "configCode": "",
                 "sign": "9cc99c9d-94aa-44b4-aa79-41227a5385d7", "searchWord": "REITs", "orderBy": "related",
                 "searchBy": "all", "appendixType": "", "granularity": "ALL", "isSearchForced": "0", "filters": [],
                 "pageNo": 1, "pageSize": 10, "isAdvancedSearch": None, "isDefaultAdvanced": None,
                 "advancedFilters": None, "advancedFilters ": None, "historySearchWords": []}
    data_post = json.dumps(data_post)
    req = requests.post(url, headers=headers, data=data_post, proxies=ip)
    req.encoding = req.apparent_encoding
    return int(req.json()['data']['pager']['pageCount'])


def getDataJson(page):
    ip = baseCore.get_proxy()
    url = 'http://www.gxzf.gov.cn/irs/front/search'
    data_post = {"code": "181aedaa542", "dataTypeId": "241", "configCode": "",
                 "sign": "9cc99c9d-94aa-44b4-aa79-41227a5385d7", "searchWord": "REITs", "orderBy": "related",
                 "searchBy": "all", "appendixType": "", "granularity": "ALL", "isSearchForced": "0", "filters": [],
                 "pageNo": page, "pageSize": 10, "isAdvancedSearch": None, "isDefaultAdvanced": None,
                 "advancedFilters": None, "advancedFilters ": None, "historySearchWords": []}
    data_post = json.dumps(data_post)
    req = requests.post(url, headers=headers, data=data_post, proxies=ip)
    req.encoding = req.apparent_encoding
    return req.json()['data']['middle']['listAndBox']


def getContent(url, publishDate, num):
    fjhref_list = ''
    fjtitle_list = ''
    url_ = url.split('/')[-1]
    url_ = url.replace(url_, '')
    soup = getSoup(url)
    contentWithTag = soup.find('div', attrs={'id': 'articleFile'})
    try:
        scripts = contentWithTag.find_all('script')
        for script in scripts:
            script.decompose()
    except:
        pass
    try:
        styles = contentWithTag.find_all('style')
        for style in styles:
            style.decompose()
    except:
        pass
    content = contentWithTag.text
    img_list = contentWithTag.find_all('img')
    num_ = 1
    for img in img_list:
        fj_href = img.get('src')
        fjhref_list += fj_href + '\n'
        if 'http' not in fj_href:
            fj_href = url_ + fj_href
        fj_title = img.get('title')
        if fj_title == '':
            fj_title = str(num_)
        category = os.path.splitext(fj_href)[1]
        if category not in fj_title:
            fj_title = fj_title + category
        fj_title = f'{num}-{publishDate[:10]}-{fj_title}'
        fjtitle_list += fj_title + '\n'
        fjcontent = getFjContent(fj_href)
        file = f'./相关政策/广西壮族自治区人民政府/政策文件/{fj_title}'
        with open(file, 'wb') as f:
            f.write(fjcontent)
        log.info(f'{fj_title}===附件下载成功')
    a_list = soup.find('div', class_='downloadfile').find_all('a')
    for a in a_list:
        fj_href = a.get('href')
        if 'http' not in fj_href:
            fj_href = url_ + fj_href
        fjhref_list += fj_href + '\n'
        fj_title = a.text.lstrip().strip()
        category = os.path.splitext(fj_href)[1]
        if category not in fj_title:
            fj_title = fj_title + category
        fj_title = f'{num}-{publishDate[:10]}-{fj_title}'
        fjtitle_list += fj_title + '\n'
        fjcontent = getFjContent(fj_href)
        file = f'./相关政策/广西壮族自治区人民政府/政策文件/{fj_title}'
        with open(file, 'wb') as f:
            f.write(fjcontent)
        log.info(f'{fj_title}===附件下载成功')
    fjhref_list = fjhref_list.lstrip().strip()
    fjtitle_list = fjtitle_list.lstrip().strip()
    return content,fjtitle_list,fjhref_list


def getData(data_, num):
    title = data_['data']['title']
    publishDate = data_['data']['time']
    origin = '广西壮族自治区人民政府'
    href = data_['data']['url']
    writtenDate = data_['data']['table-10']
    organ = data_['data']['source']
    pub_hao = data_['data']['table-5']
    summary = data_['data']['table-7']
    content, fjtitle_list, fjhref_list = getContent(href, publishDate, num)
    data = [num, title, publishDate, origin, href, writtenDate, organ, pub_hao, summary, content, fjtitle_list,
            fjhref_list]
    return data


def doJob():
    if not os.path.exists('./相关政策/广西壮族自治区人民政府/政策文件'):
        os.makedirs('./相关政策/广西壮族自治区人民政府/政策文件')
    data_list = []
    num = 1
    total = getTotal()
    for page in range(1, total + 1):
        data_json = getDataJson(page)
        title_list = []
        for data_ in data_json:
            title = data_['data']['title']
            if title not in title_list:
                title_list.append(title)
                data = getData(data_, num)
                data_list.append(data)
                log.info(f'{title}===采集成功')
                num += 1
                time.sleep(2)
    df = pd.DataFrame(np.array(data_list))
    df.columns = ['序号', '标题', '发布时间', '来源', '原文链接', '发文时间', '发文机构', '发文字号', '摘要', '正文', '附件名称', '附件连接']
    df.to_excel('./相关政策/江西省人民政府/广西壮族自治区人民政府政策文件.xlsx', index=False)


if __name__ == '__main__':
    doJob()
    baseCore.close()
