package com.zzsn.code.base.core.util.treeutil;



import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Entity基类
 * @author hydsj
 */
public class BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 协会id
     */

    private String fkOwnerId;

    /**
     * 协会名称
     */

    private String fkOwnerName;

    /**
     * 机构ID
     */

    private String fkOrgSid;

    /**
     * 部门ID
     */

    private Long fkDeptId;

    /**
     * 搜索值
     */

    private String searchValue;

    /**
     * 创建者
     */

    protected String createBy;

    /**
     * 创建者名称
     */

    protected String createByName;

    /**
     * 创建时间
     */

    protected Date createTime;

    /**
     * 更新者
     */

    protected String updateBy;

    /**
     * 更新者名称
     */

    protected String updateByName;

    /**
     * 更新时间
     */

    protected Date updateTime;

    /**
     * 备注
     */

    private String remark;

    /**
     * 请求参数
     */

    private Map<String, Object> params;

    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, Object> getParams() {
        if (params == null) {
            params = new HashMap<>();
        }
        return params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getCreateByName() {
        return createByName;
    }

    public void setCreateByName(String createByName) {
        this.createByName = createByName;
    }

    public String getUpdateByName() {
        return updateByName;
    }

    public void setUpdateByName(String updateByName) {
        this.updateByName = updateByName;
    }

    public String getFkOwnerId() {
        return fkOwnerId;
    }

    public void setFkOwnerId(String fkOwnerId) {
        this.fkOwnerId = fkOwnerId;
    }

    public String getFkOwnerName() {
        return fkOwnerName;
    }

    public void setFkOwnerName(String fkOwnerName) {
        this.fkOwnerName = fkOwnerName;
    }

    public String getFkOrgSid() {
        return fkOrgSid;
    }

    public void setFkOrgSid(String fkOrgSid) {
        this.fkOrgSid = fkOrgSid;
    }

    public Long getFkDeptId() {
        return fkDeptId;
    }

    public void setFkDeptId(Long fkDeptId) {
        this.fkDeptId = fkDeptId;
    }
}
