package com.zzsn.code.base.core.util.logutil;

import javax.net.ssl.*;
import java.io.*;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class LogUtil {

    private static final String url = "http://localhost:8801/log/add";

    public static void main(String[] args){
        ClbLog clbLog = new ClbLog();
        //clbLog.setId("123123"); id服务自动生成，无需指定
        //clbLog.setServerIp("1.1.1.1"); 此项为自动获取，无需指定
        clbLog.setDataType("信息源");
        clbLog.setDataId("123123");
        clbLog.setEvent("采集");
        clbLog.setDataIds(Arrays.asList("123456","456123"));
        clbLog.setContent("信息源：[冶金网],资讯采集完成,本次采集到数据10条");
        clbLog.setFlag("成功");
        clbLog.setProject("clb");
        clbLog.setSource("采集集群");
        clbLog.setUserIp("1.1.1.1");
        clbLog.setUserId("123123");
        clbLog.setUserName("user");
        clbLog.setOldData("{\"id\":\"123123\",\"name\":\"张三\"}");
        clbLog.setNewData("{\"id\":\"123123\",\"name\":\"李四\"}");
        clbLog.setTime(100);
        clbLog.setCollect("信息源采集");
        clbLog.setDataCount(10);
        System.out.println(LogUtil.save(clbLog));
        System.out.println(LogUtil.save("资讯","123456","编辑","修改xxxxxx","123","name"));
    }

    /**
     * 保存日志
     * @param clbLog
     * @return
     */
    public static String save(ClbLog clbLog){
        try {
            return LogUtil.postJson(url, formatJson(clbLog));
        } catch (Exception e) {
            //保存日志信息失败
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 保存日志
     * @param clbLog
     * @return
     */
    public static String save(String dUrl,ClbLog clbLog){
        try {
            return LogUtil.postJson(dUrl, formatJson(clbLog));
        } catch (Exception e) {
            //保存日志信息失败
            e.printStackTrace();
            return null;
        }
    }
    /**
     * 保存日志 (常用字段)
     * @param dataType 数据类型
     * @param dataId 数据id
     * @param event 操作类型
     * @param content 操作内容
     * @param userId 操作人id
     * @param userName 操作人
     * @return
     */
    public static String save(String dataType,String dataId,String event,String content,String userId,String userName) {
        ClbLog clbLog = new ClbLog();
        clbLog.setProject("clb");
        clbLog.setFlag("成功");
        clbLog.setDataType(dataType);
        clbLog.setDataId(dataId);
        clbLog.setEvent(event);
        clbLog.setContent(content);
        clbLog.setUserId(userId);
        clbLog.setUserName(userName);
        clbLog.setTime(100);
        clbLog.setDataCount(10);
        return LogUtil.save(clbLog);
    }
    private static final String CTYPE_JSON = "application/json; charset=utf-8";
    private static final String charset = "utf-8";

    /**
     * 以application/json; charset=utf-8方式传输
     *
     * @param url
     * @param jsonContent
     * @return
     * @throws SocketTimeoutException
     * @throws IOException
     */
    public static String postJson(String url, String jsonContent) throws IOException {
        return doRequest("POST", url, jsonContent, 15000, 15000, CTYPE_JSON,
                null);
    }

    /**
     *
     * <p>@Description: </p>
     * @Title doRequest
     * @author zhouyy
     * @param method 请求的method post/get
     * @param url 请求url
     * @param requestContent  请求参数
     * @param connectTimeout  请求超时
     * @param readTimeout 响应超时
     * @param ctype 请求格式  xml/json等等
     * @param headerMap 请求header中要封装的参数
     * @return
     * @date: 2019年10月14日 下午3:47:35
     */
    private static String doRequest(String method, String url, String requestContent,
                             int connectTimeout, int readTimeout, String ctype,
                             Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = getConnection(new URL(url), method, ctype, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);

            if(requestContent != null && requestContent.trim().length() >0){
                out = conn.getOutputStream();
                out.write(requestContent.getBytes(charset));
            }

            rsp = getResponseAsString(conn);
        } finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method,
                                            String ctype, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0],
                        new TrustManager[] { new DefaultTrustManager() },
                        new SecureRandom());
            } catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection) url
                    .openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier() {
                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection) url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept",
                "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static String getResponseAsString(HttpURLConnection conn)
            throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return getStreamAsString(conn.getInputStream(), charset, conn);
        } else {
            String msg = getStreamAsString(es, charset, conn);
            if (msg != null && msg.trim().length() >0) {
                throw new IOException(conn.getResponseCode() + ":"
                        + conn.getResponseMessage());
            } else {
                return msg;
            }
        }
    }

    private static String getStreamAsString(InputStream stream, String charset,
                                     HttpURLConnection conn) throws IOException {
        try {
            Reader reader = new InputStreamReader(stream, charset);

            StringBuilder response = new StringBuilder();
            final char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }

            return response.toString();
        } finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
    private static class DefaultTrustManager implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }
        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType)
                throws CertificateException {
        }
    }
    //jdk原生转 对象转json
    private static String formatJson(Object o) throws Exception {
        char objectBegin = '{';
        char objectEnd = '}';
        char delimiter = ',';
        char arrayBegin = '[';
        char arrayEnd = ']';
        char quote = '"';
        char colon = ':'; // 冒号
        // 返回null, 可以根据返回值决定是否将该值加入json串, 默认为null不加入
        if (o == null) {
            return null;
        }

        Class<?> klass = o.getClass();
        // 先判断是否是原始类型
        if (isPrimitive(klass)) {
            return String.valueOf(o);
        }

        if (String.class.equals(klass)) {
            return new StringBuilder()
                    .append(quote)
                    .append(o.toString().replace("\"","\\\""))
                    .append(quote)
                    .toString();
        }

        // 集合类
        if (Collection.class.isAssignableFrom(klass)) {
            StringBuilder sb = new StringBuilder();
            sb.append(arrayBegin);
            Collection c = (Collection) o;
            for (Object item : c) {
                String s = formatJson(item);
                if (s == null) {
                    continue; // 跳过null值
                } else {
                    sb.append(s).append(delimiter);
                }
            }
            if (sb.charAt(sb.length() - 1) == delimiter) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(arrayEnd);
            return sb.toString();
        }

        // 暂不支持Map

        // 普通POJO
        Field[] fs = o.getClass().getDeclaredFields();
        StringBuilder sb = new StringBuilder();
        sb.append(objectBegin);
        for (Field f : fs) {
            String fieldName = f.getName();
            f.setAccessible(true);
            Object fieldValue = f.get(o);
            String valueString = formatJson(fieldValue);
            if (valueString == null) {
                continue; // 跳过null属性
            }
            sb.append(quote).append(fieldName).append(quote).append(colon).append(valueString).append(delimiter);
        }
        if (sb.charAt(sb.length() - 1) == delimiter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(objectEnd);
        return sb.toString();
    }
    // 是否是原始类型(int, Integer)
    private static boolean isPrimitive(Class<?> klass) {
        if (klass.isPrimitive()) {
            return true;
        }
        try {
            Field f = klass.getField("TYPE");
            if (f != null) {
                Class<?> inClass = (Class<?>) f.get(null);
                return inClass.isPrimitive();
            }
        } catch (Exception e) {

        }
        return false;
    }
    public static class ClbLog {
        /**
         * 数据id 自动生成
         */
        private String id;
        /**
         * 所属项目  clb：克虏宝项目
         */
        private String project;
        /**
         * 操作类型  采集/创建/编辑/删除/流转
         */
        private String event;
        /**
         * 日志记录来源 服务名，各模块自定义
         */
        private String source;
        /**
         * 处理耗时 单位：毫秒
         */
        private Integer time;
        /**
         * 操作时间 格式：yyyy-MM-dd HH:mm:ss
         */
        private String createTime;
        /**
         * 处理数据量  本次采集条数、去重批处理条数等
         */
        private Integer dataCount;
        /**
         * 数据类型 资讯、信息源、关键词组等
         */
        private String dataType;
        /**
         * 数据id 处理数据id、采集信息源id、关键词组id、批处理任务id
         */
        private String dataId;
        /**
         * 数据组id（数组） 批处理数据id列表
         */
        private List<String> dataIds;
        /**
         * 处理结果  成功/失败
         */
        private String flag;
        /**
         * 采集器标识（依据source）
         */
        private String collect;
        /**
         * 操作人ip  操作用户ip
         */
        private String userIp;
        /**
         * 服务ip 处理服务器ip
         */
        private String serverIp;
        /**
         * 操作说明 本次操作内容描述
         */
        private String content;
        /**
         * 操作人id
         */
        private String userId;
        /**
         * 原数据，编辑前数据
         */
        private String oldData;
        /**
         * 新数据，编辑后数据
         */
        private String newData;
        /**
         * 操作人名称
         */
        private String userName;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProject() {
            return project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public String getEvent() {
            return event;
        }

        public void setEvent(String event) {
            this.event = event;
        }

        public String getSource() {
            return source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public Integer getTime() {
            return time;
        }

        public void setTime(Integer time) {
            this.time = time;
        }

        public String getCreateTime() {
            return createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public Integer getDataCount() {
            return dataCount;
        }

        public void setDataCount(Integer dataCount) {
            this.dataCount = dataCount;
        }

        public String getDataType() {
            return dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getDataId() {
            return dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public List<String> getDataIds() {
            return dataIds;
        }

        public void setDataIds(List<String> dataIds) {
            this.dataIds = dataIds;
        }

        public String getFlag() {
            return flag;
        }

        public void setFlag(String flag) {
            this.flag = flag;
        }

        public String getCollect() {
            return collect;
        }

        public void setCollect(String collect) {
            this.collect = collect;
        }

        public String getUserIp() {
            return userIp;
        }

        public void setUserIp(String userIp) {
            this.userIp = userIp;
        }

        public String getServerIp() {
            return serverIp;
        }

        public void setServerIp(String serverIp) {
            this.serverIp = serverIp;
        }

        public String getContent() {
            return content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getOldData() {
            return oldData;
        }

        public void setOldData(String oldData) {
            this.oldData = oldData;
        }

        public String getNewData() {
            return newData;
        }

        public void setNewData(String newData) {
            this.newData = newData;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public String toString() {
            return "ClbLog{" +
                    "id='" + id + '\'' +
                    ", project='" + project + '\'' +
                    ", event='" + event + '\'' +
                    ", source='" + source + '\'' +
                    ", time=" + time +
                    ", createTime='" + createTime + '\'' +
                    ", dataCount=" + dataCount +
                    ", dataType='" + dataType + '\'' +
                    ", dataId='" + dataId + '\'' +
                    ", dataIds=" + dataIds +
                    ", flag='" + flag + '\'' +
                    ", collect='" + collect + '\'' +
                    ", userIp='" + userIp + '\'' +
                    ", serverIp='" + serverIp + '\'' +
                    ", content='" + content + '\'' +
                    ", userId='" + userId + '\'' +
                    ", oldData='" + oldData + '\'' +
                    ", newData='" + newData + '\'' +
                    ", userName='" + userName + '\'' +
                    '}';
        }
    }
}
