package com.zzsn.code.base.core.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author luyuen
 */
public class BaseTools {
    private static int seq = 0;
    private static final int MAX_PER_SECOND = 1000;
    /**
     * 生成15位的数字流水号(16位以后会出现科学计数影响业务操作)
     * <p>
     * <I>生成规则为:</I><b>yyMMddHHmmss+3位顺序号</b>
     * </p>
     *
     * @return 15位流水号
     */
    public static synchronized String getNextSeq() {
        seq++;
        return (new SimpleDateFormat("yyMMddHHmmss").format(new Date()))
                + String.format("%03d", seq %= MAX_PER_SECOND);
    }
    /**
     *
     * @param type 类型 1 yyyy-MM-dd HH:mm:ss 2 yyyy-MM-dd 3yyyyMMdd
     * @return 当前时间格式化后的字符串
     */
    public static String getNowTime(int type){
        SimpleDateFormat simpleDateFormat = null;
        Date now = new Date();
        switch (type){
            case 1:
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            case 2:
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                break;
            case 3:
                simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                break;
            default:
                break;
        }
        return  simpleDateFormat.format(now);
    }
}
