#### 0.创建有数据的索引

##### 创建索引

```
PUT /basedatatest
{
   "mappings" : {
      "properties" : {
        "attachmentIds" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "author" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "authorRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "batchNo" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "checkStatus" : {
          "type" : "long"
        },
        "clbId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "content" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentHash" : {
          "type" : "long"
        },
        "contentRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentSimilar" : {
          "type" : "long"
        },
        "contentWithTag" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentWithTagRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "createDate" : {
          "type" : "date"
        },
        "deleteFlag" : {
          "type" : "long"
        },
        "downLoadUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "id" : {
          "type" : "keyword"
        },
        "importance" : {
          "type" : "long"
        },
        "infoSourceType" : {
          "type" : "keyword"
        },
        "keyWords" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword"
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "labels" : {
          "type" : "nested",
          "properties" : {
            "hitRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelMark" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemaks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "projectLabelId;" : {
              "type" : "keyword"
            },
            "relationId" : {
              "type" : "keyword"
            },
            "relationName" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "status" : {
              "type" : "integer"
            }
          }
        },
        "lang" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "langRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "origin" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originalDate" : {
          "type" : "date"
        },
        "originalTime" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "publishDate" : {
          "type" : "date"
        },
        "repeatId" : {
          "type" : "long"
        },
        "screenShotImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "sid" : {
          "type" : "keyword"
        },
        "similarTp" : {
          "type" : "long"
        },
        "source" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "sourceAddress" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "subjectId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "summary" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "summaryRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "title" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleDistinctId" : {
          "type" : "long"
        },
        "titleHash" : {
          "type" : "long"
        },
        "titleRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleSimilar" : {
          "type" : "long"
        },
        "topNum" : {
          "type" : "long"
        },
        "type" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "videoImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoPhoneUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoTime" : {
          "type" : "long"
        },
        "videoUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        }
      }
    }
}
```

##### 添加数据

```
POST /basedatatest/_doc/1
{
    "id": 1,
    "sid": "1",
    "title": "zzsn is a company",
    "content": "I'm testing data moving for es"
}
```



#### 1. 创建一个中间索引
##### 创建Mapping

```
PUT /basedatatest_temp
{
   "mappings" : {
      "properties" : {
        "attachmentIds" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "author" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "authorRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "batchNo" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "checkStatus" : {
          "type" : "long"
        },
        "clbId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "content" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentHash" : {
          "type" : "long"
        },
        "contentRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentSimilar" : {
          "type" : "long"
        },
        "contentWithTag" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentWithTagRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "createDate" : {
          "type" : "date"
        },
        "deleteFlag" : {
          "type" : "long"
        },
        "downLoadUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "id" : {
          "type" : "keyword"
        },
        "importance" : {
          "type" : "long"
        },
        "infoSourceType" : {
          "type" : "keyword"
        },
        "keyWords" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword"
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "labels" : {
          "type" : "nested",
          "properties" : {
            "hitRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelMark" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemaks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "projectLabelId;" : {
              "type" : "keyword"
            },
            "relationId" : {
              "type" : "keyword"
            },
            "relationName" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "status" : {
              "type" : "integer"
            }
          }
        },
        "lang" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "langRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "origin" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originalDate" : {
          "type" : "date"
        },
        "originalTime" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "publishDate" : {
          "type" : "date"
        },
        "repeatId" : {
          "type" : "long"
        },
        "screenShotImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "sid" : {
          "type" : "keyword"
        },
        "similarTp" : {
          "type" : "long"
        },
        "source" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "sourceAddress" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "subjectId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "summary" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "summaryRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "title" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleDistinctId" : {
          "type" : "long"
        },
        "titleHash" : {
          "type" : "long"
        },
        "titleRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleSimilar" : {
          "type" : "long"
        },
        "topNum" : {
          "type" : "long"
        },
        "type" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "videoImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoPhoneUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoTime" : {
          "type" : "long"
        },
        "videoUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        }
      }
    }
}
```




#### 2. 向中间索引备份源索引的数据

```
POST _reindex
{
  "source": {
    "index": "basedatatest"
  },
  "dest": {
    "index": "basedatatest_temp"
  }
}
```




#### 3.查询确认数据是否copy过去
```
GET /basedatatest/type/_search

GET /basedatatest_temp/type/_search
```




#### 4.删除有问题的索引
##### 删除有问题的索引
```
DELETE basedatatest
```




#### 5.重新创建同名的索引(★字段类型修改正确★)
##### 创建Mapping
```
PUT /basedatatest
{
   "mappings" : {
      "properties" : {
        "attachmentIds" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "author" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "authorRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "batchNo" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "checkStatus" : {
          "type" : "long"
        },
        "clbId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "content" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentHash" : {
          "type" : "long"
        },
        "contentRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentSimilar" : {
          "type" : "long"
        },
        "contentWithTag" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "contentWithTagRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "createDate" : {
          "type" : "date"
        },
        "deleteFlag" : {
          "type" : "long"
        },
        "downLoadUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "id" : {
          "type" : "keyword"
        },
        "importance" : {
          "type" : "long"
        },
        "infoSourceType" : {
          "type" : "keyword"
        },
        "keyWords" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword"
            }
          },
          "analyzer" : "ik_max_word",
          "search_analyzer" : "ik_smart"
        },
        "labels" : {
          "type" : "nested",
          "properties" : {
            "hitRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelMark" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemaks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "labelRemarks" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "projectLabelId;" : {
              "type" : "keyword"
            },
            "relationId" : {
              "type" : "keyword"
            },
            "relationName" : {
              "type" : "text",
              "analyzer" : "ik_max_word"
            },
            "status" : {
              "type" : "integer"
            }
          }
        },
        "lang" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "langRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "origin" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originRaw" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "originalDate" : {
          "type" : "date"
        },
        "originalTime" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "publishDate" : {
          "type" : "date"
        },
        "repeatId" : {
          "type" : "long"
        },
        "screenShotImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "sid" : {
          "type" : "keyword"
        },
        "similarTp" : {
          "type" : "long"
        },
        "source" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "sourceAddress" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "subjectId" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          }
        },
        "summary" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "summaryRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "title" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleDistinctId" : {
          "type" : "long"
        },
        "titleHash" : {
          "type" : "long"
        },
        "titleRaw" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "titleSimilar" : {
          "type" : "long"
        },
        "topNum" : {
          "type" : "long"
        },
        "type" : {
          "type" : "text",
          "fields" : {
            "keyword" : {
              "type" : "keyword",
              "ignore_above" : 256
            }
          },
          "analyzer" : "ik_max_word"
        },
        "videoImg" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoPhoneUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        },
        "videoTime" : {
          "type" : "long"
        },
        "videoUrl" : {
          "type" : "text",
          "analyzer" : "ik_max_word"
        }
      }
    }
}
```




#### 6. 从中间索引还原到源索引的数据
```
POST _reindex
{
  "source": {
    "index": "basedatatest_temp"
  },
  "dest": {
    "index": "basedatatest"
  }
}
```




#### 7. 删除中间索引
```
DELETE basedatatest_temp
```

