## 非开发人员整体操作流程



![](.\img\1.png)

#### 新增数据源

1. 一般使用已有的接口，如不满足需求按需新增；
2. 新增包括接口访问路径和响应数据类型，响应数据类型包含对象和列表

#### 新增数据集

1. 目的：通过调用若干个数据源接口为报告提供多种数据；
2. 操作：
   1. 选择合适的数据集组；
   2. 选择所需的数据源，并添加应有的参数，定义与模板对应的响应参数；
   3. 出参、入参不重不漏

#### 模板管理：上传模板

1. 按照报告需求准备以word形式准备模板
2. 模板中专题与创建的专题一一对应
3. 特殊个性化的数据需要增加数据源
4. 数据支持两种类型：对象和列表
5. 定义的数据要与新增数据集中数据源响应参数定义的一一对应
6. 在后台上传并选择对应的数据集

#### 任务管理:新增任务

1. 选择填写任务基本信息
2. 选择填写报告基本信息
3. 完善任务执行周期数据
4. 点击提交

## 开发人员参考文档

### 相关的表关系图


![](.\img\克虏宝-第 9 页.png)



### 数据源

#### 表设计

**clb_report_data_source**

##### 建表语句

```sql
CREATE TABLE `clb_report_data_source` (
  `id` varchar(36) NOT NULL COMMENT '主键id',
  `data_source_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '名称',
  `url` varchar(255) NOT NULL COMMENT '路径',
  `params` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '参数',
  `type` int NOT NULL COMMENT '返回数据类型',
  `data_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '返回对象',
  `remark` varchar(255) DEFAULT NULL COMMENT '说明',
  `status` int DEFAULT '0' COMMENT '状态(0-正常；1-禁用)',
  `source_type` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '信息源类型id',
  `delete_status` int DEFAULT '0' COMMENT '是否删除(0-否;1-是)',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='数据源表';
```

#### 接口

##### 数据源-分页列表

> BASIC

**Path:** /clb/report/dataSource/pageList

**Method:** GET

> REQUEST

**Query:**

| name       | value | required | desc                 |
| ---------- | ----- | -------- | -------------------- |
| name       |       | NO       | 名称                 |
| sourceType |       | NO       | 信息源类型id         |
| startTime  |       | NO       | 开始时间             |
| endTime    |       | NO       | 结束时间             |
| status     |       | NO       | 状态(0-正常；1-禁用) |
| pageNo     | 1     | YES      | 当前页               |
| pageSize   | 10    | YES      | 返回条数             |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {},
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {}
}
```



------

##### 数据源-新增

> BASIC

**Path:** /clb/report/dataSource/add

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name           | type    | desc                 |
| -------------- | ------- | -------------------- |
| id             | string  | 主键id               |
| dataSourceName | string  | 名称                 |
| url            | string  | 路径                 |
| params         | string  | 参数                 |
| type           | integer | 返回数据类型         |
| dataName       | string  | 返回对象             |
| remark         | string  | 说明                 |
| status         | integer | 状态(0-正常；1-禁用) |
| deleteStatus   | integer | 是否删除(0-否;1-是)  |
| sourceType     | string  | 信息源类型id         |
| createBy       | string  | 创建人               |
| createTime     | string  | 创建时间             |

**Request Demo:**

```json
{
  "id": "",
  "dataSourceName": "",
  "url": "",
  "params": "",
  "type": 0,
  "dataName": "",
  "remark": "",
  "status": 0,
  "deleteStatus": 0,
  "sourceType": "",
  "createBy": "",
  "createTime": ""
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



------

##### 数据源-编辑

> BASIC

**Path:** /clb/report/dataSource/update

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name           | type    | desc                 |
| -------------- | ------- | -------------------- |
| id             | string  | 主键id               |
| dataSourceName | string  | 名称                 |
| url            | string  | 路径                 |
| params         | string  | 参数                 |
| type           | integer | 返回数据类型         |
| dataName       | string  | 返回对象             |
| remark         | string  | 说明                 |
| status         | integer | 状态(0-正常；1-禁用) |
| deleteStatus   | integer | 是否删除(0-否;1-是)  |
| sourceType     | string  | 信息源类型id         |
| createBy       | string  | 创建人               |
| createTime     | string  | 创建时间             |

**Request Demo:**

```json
{
  "id": "",
  "dataSourceName": "",
  "url": "",
  "params": "",
  "type": 0,
  "dataName": "",
  "remark": "",
  "status": 0,
  "deleteStatus": 0,
  "sourceType": "",
  "createBy": "",
  "createTime": ""
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



### 数据集

#### 表设计

- clb_report_business_type
- clb_report_data_set

##### 建表语句

```sql
CREATE TABLE `clb_report_business_type` (
  `id` varchar(36) NOT NULL COMMENT '主键id',
  `type_name` varchar(50) DEFAULT NULL COMMENT '分类名称',
  `pid` varchar(36) DEFAULT NULL COMMENT '上级id',
  `has_child` int DEFAULT NULL COMMENT '是否有下级(1-是;0-否)',
  `level` int DEFAULT NULL COMMENT '层级',
  `top_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '最上级id',
  `category` int DEFAULT NULL COMMENT '类别(1-模板;2-报告任务;3-报告)',
  `delete_status` int DEFAULT '0' COMMENT '是否删除(0-否;1-是)',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `project_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='报告业务分类';
```

```sql
CREATE TABLE `clb_report_data_set` (
  `id` varchar(36) NOT NULL COMMENT '主键id',
  `data_set_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据集名称',
  `param_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '参数值',
  `description` varchar(500) DEFAULT NULL COMMENT '描述',
  `status` int DEFAULT '0' COMMENT '状态(1-正常;0-禁用)',
  `delete_status` int DEFAULT '0' COMMENT '是否删除(0-否;1-是)',
  `create_by` varchar(255) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `type` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据集分类id',
  `project_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='数据集表';
```



#### 接口

##### 分类树

> BASIC

**Path:** /clb/report/businessType/treeList

**Method:** GET

> REQUEST

**Query:**

| name | value | required | desc                                                 |
| ---- | ----- | -------- | ---------------------------------------------------- |
| type |       | YES      | 分类类型(1-模板;2-报告任务;3-报告;4-数据源;5-数据集) |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                         | type    | desc               |
| ------------------------------------------------------------ | ------- | ------------------ |
| success                                                      | boolean | 成功标志           |
| message                                                      | string  | 返回处理消息       |
| code                                                         | integer | 返回代码           |
| result                                                       | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─isReportType                              | boolean |                    |
| &ensp;&ensp;&#124;─projectId                                 | string  |                    |
| &ensp;&ensp;&#124;─projectName                               | string  |                    |
| &ensp;&ensp;&#124;─id                                        | string  |                    |
| &ensp;&ensp;&#124;─name                                      | string  |                    |
| &ensp;&ensp;&#124;─pid                                       | string  |                    |
| &ensp;&ensp;&#124;─level                                     | integer |                    |
| &ensp;&ensp;&#124;─orderNo                                   | integer |                    |
| &ensp;&ensp;&#124;─hasChild                                  | integer |                    |
| &ensp;&ensp;&#124;─children                                  | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name              | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid               | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─level             | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─orderNo           | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild          | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children          | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─level | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─orderNo | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ | object  |                    |
| timestamp                                                    | integer | 时间戳             |
| handleMsg                                                    | string  | python接口返回     |
| isHandleSuccess                                              | boolean | python接口返回状态 |
| logs                                                         | string  | python接口返回状态 |
| resultData                                                   | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─isReportType                              | boolean |                    |
| &ensp;&ensp;&#124;─projectId                                 | string  |                    |
| &ensp;&ensp;&#124;─projectName                               | string  |                    |
| &ensp;&ensp;&#124;─id                                        | string  |                    |
| &ensp;&ensp;&#124;─name                                      | string  |                    |
| &ensp;&ensp;&#124;─pid                                       | string  |                    |
| &ensp;&ensp;&#124;─level                                     | integer |                    |
| &ensp;&ensp;&#124;─orderNo                                   | integer |                    |
| &ensp;&ensp;&#124;─hasChild                                  | integer |                    |
| &ensp;&ensp;&#124;─children                                  | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name              | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid               | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─level             | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─orderNo           | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild          | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children          | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─level | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─orderNo | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ | object  |                    |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "isReportType": false,
    "projectId": "",
    "projectName": "",
    "id": "",
    "name": "",
    "pid": "",
    "level": 0,
    "orderNo": 0,
    "hasChild": 0,
    "children": [
      {
        "id": "",
        "name": "",
        "pid": "",
        "level": 0,
        "orderNo": 0,
        "hasChild": 0,
        "children": [
          {
            "id": "",
            "name": "",
            "pid": "",
            "level": 0,
            "orderNo": 0,
            "hasChild": 0,
            "children": []
          }
        ]
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "isReportType": false,
    "projectId": "",
    "projectName": "",
    "id": "",
    "name": "",
    "pid": "",
    "level": 0,
    "orderNo": 0,
    "hasChild": 0,
    "children": [
      {
        "id": "",
        "name": "",
        "pid": "",
        "level": 0,
        "orderNo": 0,
        "hasChild": 0,
        "children": [
          {
            "id": "",
            "name": "",
            "pid": "",
            "level": 0,
            "orderNo": 0,
            "hasChild": 0,
            "children": []
          }
        ]
      }
    ]
  }
}
```

##### 数据集分页列表

> BASIC

**Path:** /clb/report/dataSet/pageList

**Method:** GET

> REQUEST

**Query:**

| name      | value | required | desc         |
| --------- | ----- | -------- | ------------ |
| projectId |       | NO       | 项目id       |
| type      |       | NO       | 数据集分类id |
| pageNo    | 1     | YES      | 当前页       |
| pageSize  | 10    | YES      | 返回条数     |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                        | type    | desc               |
| ----------------------------------------------------------- | ------- | ------------------ |
| success                                                     | boolean | 成功标志           |
| message                                                     | string  | 返回处理消息       |
| code                                                        | integer | 返回代码           |
| result                                                      | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                    | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                     | string  | 页容量             |
| &ensp;&ensp;&#124;─current                                  | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                    | string  | 总页数             |
| &ensp;&ensp;&#124;─record                                   | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                             | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id               | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSetName      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─paramValue       | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─template         | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─description      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status           | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime       | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─templateNameList | array   | 模板名称集合       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─     | string  |                    |
| timestamp                                                   | integer | 时间戳             |
| handleMsg                                                   | string  | python接口返回     |
| isHandleSuccess                                             | boolean | python接口返回状态 |
| logs                                                        | string  | python接口返回状态 |
| resultData                                                  | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                    | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                     | string  | 页容量             |
| &ensp;&ensp;&#124;─current                                  | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                    | string  | 总页数             |
| &ensp;&ensp;&#124;─record                                   | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                             | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id               | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSetName      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─paramValue       | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─template         | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─description      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status           | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime       | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─templateNameList | array   | 模板名称集合       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─     | string  |                    |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "dataSetName": "",
        "paramValue": "",
        "template": "",
        "description": "",
        "status": 0,
        "createTime": "",
        "templateNameList": [
          ""
        ]
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "dataSetName": "",
        "paramValue": "",
        "template": "",
        "description": "",
        "status": 0,
        "createTime": "",
        "templateNameList": [
          ""
        ]
      }
    ]
  }
}
```

##### 数据集-新增/编辑

> BASIC

**Path:** /clb/report/dataSet/saveOrUpdate

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name                                        | type    | desc                      |
| ------------------------------------------- | ------- | ------------------------- |
| id                                          | string  | 主键id                    |
| dataSetName                                 | string  | 数据集名称                |
| paramValue                                  | string  | 参数值                    |
| description                                 | string  | 描述                      |
| status                                      | integer | 状态(0-正常;1-禁用)       |
| deleteStatus                                | integer | 是否删除(0-否;1-是)       |
| type                                        | string  | 数据集分类id              |
| projectId                                   | string  | 项目id                    |
| createBy                                    | string  | 创建人                    |
| createTime                                  | string  | 创建时间                  |
| sourceForms                                 | array   | 数据源id集合              |
| &ensp;&ensp;&#124;─                         | object  |                           |
| &ensp;&ensp;&ensp;&ensp;&#124;─dataSourceId | string  | 数据源id                  |
| &ensp;&ensp;&ensp;&ensp;&#124;─paramValue   | string  | 数据源参数值              |
| &ensp;&ensp;&ensp;&ensp;&#124;─returnObject | string  | 数据源返回对象-与模板对应 |

**Request Demo:**

```json
{
  "id": "",
  "dataSetName": "",
  "paramValue": "",
  "description": "",
  "status": 0,
  "deleteStatus": 0,
  "type": "",
  "projectId": "",
  "createBy": "",
  "createTime": "",
  "sourceForms": [
    {
      "dataSourceId": "",
      "paramValue": "",
      "returnObject": ""
    }
  ]
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```

##### 获取数据集详情

包含数据源，项目以及分类信息

> BASIC

**Path:** /clb/report/dataSet/detail

**Method:** GET

> REQUEST

**Query:**

| name      | value | required | desc     |
| --------- | ----- | -------- | -------- |
| dateSetId |       | YES      | 数据集id |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                      | type    | desc                                         |
| --------------------------------------------------------- | ------- | -------------------------------------------- |
| success                                                   | boolean | 成功标志                                     |
| message                                                   | string  | 返回处理消息                                 |
| code                                                      | integer | 返回代码                                     |
| result                                                    | object  | 返回数据对象 data                            |
| &ensp;&ensp;&#124;─id                                     | string  |                                              |
| &ensp;&ensp;&#124;─dataSetName                            | string  |                                              |
| &ensp;&ensp;&#124;─description                            | string  |                                              |
| &ensp;&ensp;&#124;─status                                 | integer |                                              |
| &ensp;&ensp;&#124;─type                                   | string  |                                              |
| &ensp;&ensp;&#124;─dateSourceList                         | array   | 一对多关系映射，一个数据集可以添加多个数据源 |
| &ensp;&ensp;&ensp;&ensp;&#124;─                           | object  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id             | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSourceId   | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSourceName | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─url            | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─paramValue     | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type           | integer |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─returnObject   | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─remark         | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status         | integer |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime     | string  |                                              |
| timestamp                                                 | integer | 时间戳                                       |
| handleMsg                                                 | string  | python接口返回                               |
| isHandleSuccess                                           | boolean | python接口返回状态                           |
| logs                                                      | string  | python接口返回状态                           |
| resultData                                                | object  | 返回数据对象 data                            |
| &ensp;&ensp;&#124;─id                                     | string  |                                              |
| &ensp;&ensp;&#124;─dataSetName                            | string  |                                              |
| &ensp;&ensp;&#124;─description                            | string  |                                              |
| &ensp;&ensp;&#124;─status                                 | integer |                                              |
| &ensp;&ensp;&#124;─type                                   | string  |                                              |
| &ensp;&ensp;&#124;─dateSourceList                         | array   | 一对多关系映射，一个数据集可以添加多个数据源 |
| &ensp;&ensp;&ensp;&ensp;&#124;─                           | object  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id             | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSourceId   | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataSourceName | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─url            | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─paramValue     | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type           | integer |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─returnObject   | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─remark         | string  |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status         | integer |                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime     | string  |                                              |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "id": "",
    "dataSetName": "",
    "description": "",
    "status": 0,
    "type": "",
    "dateSourceList": [
      {
        "id": "",
        "dataSourceId": "",
        "dataSourceName": "",
        "url": "",
        "paramValue": "",
        "type": 0,
        "returnObject": "",
        "remark": "",
        "status": 0,
        "createTime": ""
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "id": "",
    "dataSetName": "",
    "description": "",
    "status": 0,
    "type": "",
    "dateSourceList": [
      {
        "id": "",
        "dataSourceId": "",
        "dataSourceName": "",
        "url": "",
        "paramValue": "",
        "type": 0,
        "returnObject": "",
        "remark": "",
        "status": 0,
        "createTime": ""
      }
    ]
  }
}
```



### 模板管理

#### 表设计

- clb_report_template

##### 建表语句

```sql
CREATE TABLE `clb_report_template` (
  `id` varchar(36) NOT NULL COMMENT '主键id',
  `template_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '模板名称',
  `type` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '模板分类id',
  `project_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目id',
  `file_path` varchar(200) DEFAULT NULL COMMENT '文件路径',
  `cover` varchar(255) DEFAULT NULL COMMENT '封面路径',
  `preview` varchar(255) DEFAULT NULL COMMENT '预览路径',
  `content` mediumtext COMMENT '模板内容',
  `data_set_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '数据集id',
  `description` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `if_default` int DEFAULT '0' COMMENT '是否默认(0-否;1-是)',
  `status` int DEFAULT '0' COMMENT '状态(0-正常;1-禁用)',
  `delete_status` int DEFAULT '0' COMMENT '是否删除(0-否;1-是)',
  `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;
```



#### 接口

##### 报告模板-分页列表

> BASIC

**Path:** /clb/report/template/pageList

**Method:** GET

> REQUEST

**Query:**

| name      | value | required | desc                 |
| --------- | ----- | -------- | -------------------- |
| typeId    |       | NO       | 分类id               |
| projectId |       | NO       | 项目id               |
| status    |       | NO       | 状态(0-正常；1-禁用) |
| pageNo    | 1     | YES      | 当前页               |
| pageSize  | 10    | YES      | 返回条数             |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                    | type    | desc               |
| ------------------------------------------------------- | ------- | ------------------ |
| success                                                 | boolean | 成功标志           |
| message                                                 | string  | 返回处理消息       |
| code                                                    | integer | 返回代码           |
| result                                                  | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                 | string  | 页容量             |
| &ensp;&ensp;&#124;─current                              | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                | string  | 总页数             |
| &ensp;&ensp;&#124;─record                               | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                         | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id           | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─templateName | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type         | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─filePath     | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─cover        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─preview      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status       | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ifDefault    | integer |                    |
| timestamp                                               | integer | 时间戳             |
| handleMsg                                               | string  | python接口返回     |
| isHandleSuccess                                         | boolean | python接口返回状态 |
| logs                                                    | string  | python接口返回状态 |
| resultData                                              | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                 | string  | 页容量             |
| &ensp;&ensp;&#124;─current                              | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                | string  | 总页数             |
| &ensp;&ensp;&#124;─record                               | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                         | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id           | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─templateName | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type         | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─filePath     | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─cover        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─preview      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status       | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ifDefault    | integer |                    |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "templateName": "",
        "type": "",
        "filePath": "",
        "cover": "",
        "preview": "",
        "status": 0,
        "ifDefault": 0
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "templateName": "",
        "type": "",
        "filePath": "",
        "cover": "",
        "preview": "",
        "status": 0,
        "ifDefault": 0
      }
    ]
  }
}
```



------

##### 报告模板-新增/编辑

> BASIC

**Path:** /clb/report/template/saveOrUpdate

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name         | type    | desc                |
| ------------ | ------- | ------------------- |
| id           | string  | 主键id              |
| templateName | string  | 模板名称            |
| type         | string  | 模板分类            |
| projectId    | string  | 项目id              |
| filePath     | string  | 文件路径            |
| cover        | string  | 封面路径            |
| preview      | string  | 预览路径            |
| content      | string  | 模板内容            |
| dataSetId    | string  | 数据集id            |
| description  | string  | 描述                |
| status       | integer | 状态(0-正常;1-禁用) |
| ifDefault    | integer | 是否默认(0-否;1-是) |
| deleteStatus | integer | 是否删除(0-否;1-是) |
| createBy     | string  | 创建人              |
| createTime   | string  | 创建时间            |

**Request Demo:**

```json
{
  "id": "",
  "templateName": "",
  "type": "",
  "projectId": "",
  "filePath": "",
  "cover": "",
  "preview": "",
  "content": "",
  "dataSetId": "",
  "description": "",
  "status": 0,
  "ifDefault": 0,
  "deleteStatus": 0,
  "createBy": "",
  "createTime": ""
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```

### 任务管理

#### 表设计

- clb_report_task

建表语句

```sql
CREATE TABLE `clb_report_task` (
  `id` varchar(36) NOT NULL COMMENT '主键id',
  `task_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '任务名称',
  `task_type` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '任务类型id',
  `task_project_id` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '任务所属项目id',
  `description` varchar(500) DEFAULT NULL COMMENT '任务描述',
  `task_status` int DEFAULT NULL COMMENT '任务状态(0-禁用;1-正常)',
  `report_type` varchar(36) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '报告分类id',
  `report_name` varchar(200) DEFAULT NULL COMMENT '报告名称',
  `project_id` varchar(36) DEFAULT NULL COMMENT '项目id',
  `column_id` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '项目下的栏目id',
  `subject_id` varchar(500) DEFAULT NULL COMMENT '专题id',
  `report_issue` varchar(255) DEFAULT NULL COMMENT '报告刊期',
  `report_desc` varchar(500) DEFAULT NULL COMMENT '报告描述',
  `report_publish_status` int DEFAULT NULL COMMENT '发布状态(0-不发布;1-发布)',
  `template_id` varchar(36) DEFAULT NULL COMMENT '模板id',
  `execution_way` int DEFAULT NULL COMMENT '执行方式(1-重复执行;2-仅执行一次)',
  `frequency` int DEFAULT NULL COMMENT '执行频率(1-按天;2-按周;3-按月)',
  `task_cron` varchar(255) DEFAULT NULL COMMENT '任务执行cron表达式',
  `plan_description` varchar(255) DEFAULT NULL COMMENT '任务执行计划描述',
  `push` int DEFAULT NULL COMMENT '是否推送(0-否;1-是)',
  `email_scope` varchar(500) DEFAULT NULL COMMENT '邮件推送范围',
  `email_push_cron` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '邮件推送cron表达式',
  `email_push_time` varchar(50) DEFAULT NULL COMMENT '邮件推送时间拼接(前端回显使用)',
  `post_box` varchar(255) DEFAULT NULL COMMENT '发送邮箱地址',
  `weChat_scope` varchar(500) DEFAULT NULL COMMENT '微信推送范围',
  `weChat_push_time` varchar(50) DEFAULT NULL COMMENT '微信推送时间拼接(前端回显使用)',
  `weChat_push_cron` varchar(255) DEFAULT NULL COMMENT '微信推送cron表达式',
  `delete_status` int DEFAULT '0' COMMENT '是否删除(0-否;1-是)',
  `create_by` varchar(50) DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COMMENT='报告任务表';
```



#### 接口

##### 报告任务表-分页列表

> BASIC

**Path:** /clb/report/task/pageList

**Method:** GET

> REQUEST

**Query:**

| name         | value | required | desc                                  |
| ------------ | ----- | -------- | ------------------------------------- |
| typeId       |       | NO       | 报告任务分类id                        |
| projectId    |       | NO       | 项目id                                |
| taskName     |       | NO       | 报告名称                              |
| startTime    |       | NO       | 开始时间                              |
| endTime      |       | NO       | 结束时间                              |
| executionWay |       | NO       | 任务执行类型(1-重复执行;2-仅执行一次) |
| pageNo       | 1     | YES      | 当前页                                |
| pageSize     | 10    | YES      | 页面大小                              |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                       | type    | desc               |
| ---------------------------------------------------------- | ------- | ------------------ |
| success                                                    | boolean | 成功标志           |
| message                                                    | string  | 返回处理消息       |
| code                                                       | integer | 返回代码           |
| result                                                     | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                   | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                    | string  | 页容量             |
| &ensp;&ensp;&#124;─current                                 | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                   | string  | 总页数             |
| &ensp;&ensp;&#124;─record                                  | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                            | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id              | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskName        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─planDescription | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskTypeName    | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskStatus      | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─executionWay    | integer |                    |
| timestamp                                                  | integer | 时间戳             |
| handleMsg                                                  | string  | python接口返回     |
| isHandleSuccess                                            | boolean | python接口返回状态 |
| logs                                                       | string  | python接口返回状态 |
| resultData                                                 | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                                   | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                    | string  | 页容量             |
| &ensp;&ensp;&#124;─current                                 | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                                   | string  | 总页数             |
| &ensp;&ensp;&#124;─record                                  | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                            | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id              | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskName        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─planDescription | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskTypeName    | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy        | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime      | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─taskStatus      | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─executionWay    | integer |                    |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "taskName": "",
        "planDescription": "",
        "taskTypeName": "",
        "createBy": "",
        "createTime": "",
        "taskStatus": 0,
        "executionWay": 0
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "taskName": "",
        "planDescription": "",
        "taskTypeName": "",
        "createBy": "",
        "createTime": "",
        "taskStatus": 0,
        "executionWay": 0
      }
    ]
  }
}
```



------

##### 任务执行记录

> BASIC

**Path:** /clb/report/task/recordList

**Method:** GET

> REQUEST

**Query:**

| name         | value | required | desc                                  |
| ------------ | ----- | -------- | ------------------------------------- |
| typeId       |       | NO       | 报告任务分类id                        |
| projectId    |       | NO       | 项目id                                |
| taskId       |       | NO       | 任务id                                |
| taskName     |       | NO       | 任务名称                              |
| startTime    |       | NO       | 开始时间                              |
| endTime      |       | NO       | 结束时间                              |
| executionWay |       | NO       | 任务执行类型(1-重复执行;2-仅执行一次) |
| pageNo       | 1     | YES      | 当前页                                |
| pageSize     | 10    | YES      | 页面大小                              |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



------

##### 新增

> BASIC

**Path:** /clb/report/task/add

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name                                     | type    | desc                                                         |
| ---------------------------------------- | ------- | ------------------------------------------------------------ |
| id                                       | string  |                                                              |
| taskName                                 | string  | 任务名称                                                     |
| taskType                                 | string  | 任务类型id                                                   |
| taskProjectId                            | string  | 任务所属项目id                                               |
| description                              | string  | 任务描述                                                     |
| reportType                               | string  | 报告分类                                                     |
| reportName                               | string  | 报告名称                                                     |
| reportIssue                              | string  | 报告名称                                                     |
| subjectId                                | string  | 专题id                                                       |
| reportDesc                               | string  | 报告描述                                                     |
| reportPublishStatus                      | integer | 报告发布状态                                                 |
| templateId                               | string  | 模板id                                                       |
| executionWay                             | integer | 执行方式(1-重复执行;2-仅执行一次)                            |
| frequency                                | integer | 执行频率(1-按天;2-按周;3-按月)                               |
| taskWeek                                 | integer | 任务执行周几/月份中的几号，设置频率为每周/月执行的定时任务时需要 |
| taskTime                                 | string  | 任务执行时间                                                 |
| planDescription                          | string  | 任务执行计划描述                                             |
| push                                     | integer | 是否推送(0-否;1-是)                                          |
| emailPushWeek                            | integer | 邮件推送周几/月份，设置频率为每周/月执行的定时任务时需要     |
| emailScope                               | string  | 邮件推送范围                                                 |
| emailPushTime                            | string  | 邮件推送时间                                                 |
| weChatPushWeek                           | integer | 微信推送周几/月份，设置频率为每周/月执行的定时任务时需要     |
| weChatScope                              | string  | 微信推送范围                                                 |
| weChatPushTime                           | string  | 微信推送时间                                                 |
| createBy                                 | string  | 创建人                                                       |
| createTime                               | string  | 创建时间                                                     |
| reportExtendVoList                       | array   | 报告任务扩展信息                                             |
| &ensp;&ensp;&#124;─                      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─projectId | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─columnId  | string  |                                                              |

**Request Demo:**

```json
{
  "id": "",
  "taskName": "",
  "taskType": "",
  "taskProjectId": "",
  "description": "",
  "reportType": "",
  "reportName": "",
  "reportIssue": "",
  "subjectId": "",
  "reportDesc": "",
  "reportPublishStatus": 0,
  "templateId": "",
  "executionWay": 0,
  "frequency": 0,
  "taskWeek": 0,
  "taskTime": "",
  "planDescription": "",
  "push": 0,
  "emailPushWeek": 0,
  "emailScope": "",
  "emailPushTime": "",
  "weChatPushWeek": 0,
  "weChatScope": "",
  "weChatPushTime": "",
  "createBy": "",
  "createTime": "",
  "reportExtendVoList": [
    {
      "projectId": "",
      "columnId": ""
    }
  ]
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



------

##### 编辑

> BASIC

**Path:** /clb/report/task/update

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name                                     | type    | desc                                                         |
| ---------------------------------------- | ------- | ------------------------------------------------------------ |
| id                                       | string  |                                                              |
| taskName                                 | string  | 任务名称                                                     |
| taskType                                 | string  | 任务类型id                                                   |
| taskProjectId                            | string  | 任务所属项目id                                               |
| description                              | string  | 任务描述                                                     |
| reportType                               | string  | 报告分类                                                     |
| reportName                               | string  | 报告名称                                                     |
| reportIssue                              | string  | 报告名称                                                     |
| subjectId                                | string  | 专题id                                                       |
| reportDesc                               | string  | 报告描述                                                     |
| reportPublishStatus                      | integer | 报告发布状态                                                 |
| templateId                               | string  | 模板id                                                       |
| executionWay                             | integer | 执行方式(1-重复执行;2-仅执行一次)                            |
| frequency                                | integer | 执行频率(1-按天;2-按周;3-按月)                               |
| taskWeek                                 | integer | 任务执行周几/月份中的几号，设置频率为每周/月执行的定时任务时需要 |
| taskTime                                 | string  | 任务执行时间                                                 |
| planDescription                          | string  | 任务执行计划描述                                             |
| push                                     | integer | 是否推送(0-否;1-是)                                          |
| emailPushWeek                            | integer | 邮件推送周几/月份，设置频率为每周/月执行的定时任务时需要     |
| emailScope                               | string  | 邮件推送范围                                                 |
| emailPushTime                            | string  | 邮件推送时间                                                 |
| weChatPushWeek                           | integer | 微信推送周几/月份，设置频率为每周/月执行的定时任务时需要     |
| weChatScope                              | string  | 微信推送范围                                                 |
| weChatPushTime                           | string  | 微信推送时间                                                 |
| createBy                                 | string  | 创建人                                                       |
| createTime                               | string  | 创建时间                                                     |
| reportExtendVoList                       | array   | 报告任务扩展信息                                             |
| &ensp;&ensp;&#124;─                      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─projectId | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─columnId  | string  |                                                              |

**Request Demo:**

```json
{
  "id": "",
  "taskName": "",
  "taskType": "",
  "taskProjectId": "",
  "description": "",
  "reportType": "",
  "reportName": "",
  "reportIssue": "",
  "subjectId": "",
  "reportDesc": "",
  "reportPublishStatus": 0,
  "templateId": "",
  "executionWay": 0,
  "frequency": 0,
  "taskWeek": 0,
  "taskTime": "",
  "planDescription": "",
  "push": 0,
  "emailPushWeek": 0,
  "emailScope": "",
  "emailPushTime": "",
  "weChatPushWeek": 0,
  "weChatScope": "",
  "weChatPushTime": "",
  "createBy": "",
  "createTime": "",
  "reportExtendVoList": [
    {
      "projectId": "",
      "columnId": ""
    }
  ]
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```

### 报告列表

#### 表设计

- 

#### 接口

##### 报告表-分页列表

> BASIC

**Path:** /clb/report/pageList

**Method:** GET

> REQUEST

**Query:**

| name       | value | required | desc       |
| ---------- | ----- | -------- | ---------- |
| typeId     |       | NO       | 报告分类id |
| projectId  |       | NO       | 项目id     |
| reportName |       | NO       | 报告名称   |
| startTime  |       | NO       | 开始时间   |
| endTime    |       | NO       | 结束时间   |
| pageNo     | 1     | YES      | 当前页     |
| pageSize   | 10    | YES      | 返回条数   |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                   | type    | desc               |
| ------------------------------------------------------ | ------- | ------------------ |
| success                                                | boolean | 成功标志           |
| message                                                | string  | 返回处理消息       |
| code                                                   | integer | 返回代码           |
| result                                                 | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                               | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                | string  | 页容量             |
| &ensp;&ensp;&#124;─current                             | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                               | string  | 总页数             |
| &ensp;&ensp;&#124;─record                              | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                        | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id          | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─reportName  | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─reportIssue | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─filePath    | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─preview     | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectId   | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectName | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createWay   | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─description | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime  | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─publish     | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectName | string  |                    |
| timestamp                                              | integer | 时间戳             |
| handleMsg                                              | string  | python接口返回     |
| isHandleSuccess                                        | boolean | python接口返回状态 |
| logs                                                   | string  | python接口返回状态 |
| resultData                                             | object  | 返回数据对象 data  |
| &ensp;&ensp;&#124;─total                               | string  | 总条数             |
| &ensp;&ensp;&#124;─size                                | string  | 页容量             |
| &ensp;&ensp;&#124;─current                             | string  | 当前页             |
| &ensp;&ensp;&#124;─pages                               | string  | 总页数             |
| &ensp;&ensp;&#124;─record                              | array   |                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─                        | object  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id          | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─reportName  | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─reportIssue | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─filePath    | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─preview     | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectId   | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectName | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createWay   | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─description | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime  | string  |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─publish     | integer |                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectName | string  |                    |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "reportName": "",
        "reportIssue": "",
        "filePath": "",
        "preview": "",
        "subjectId": "",
        "projectName": "",
        "createWay": "",
        "description": "",
        "createTime": "",
        "publish": 0,
        "subjectName": ""
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "total": "",
    "size": "",
    "current": "",
    "pages": "",
    "record": [
      {
        "id": "",
        "reportName": "",
        "reportIssue": "",
        "filePath": "",
        "preview": "",
        "subjectId": "",
        "projectName": "",
        "createWay": "",
        "description": "",
        "createTime": "",
        "publish": 0,
        "subjectName": ""
      }
    ]
  }
}
```



##### 新增/编辑

> BASIC

**Path:** /clb/report/saveOrUpdate

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name                                     | type    | desc             |
| ---------------------------------------- | ------- | ---------------- |
| id                                       | string  |                  |
| projectId                                | string  |                  |
| typeId                                   | string  |                  |
| reportName                               | string  |                  |
| reportIssue                              | string  |                  |
| publish                                  | integer |                  |
| content                                  | string  |                  |
| createWay                                | integer |                  |
| createBy                                 | string  |                  |
| createTime                               | string  |                  |
| reportExtendVoList                       | array   | 报告任务扩展信息 |
| &ensp;&ensp;&#124;─                      | object  |                  |
| &ensp;&ensp;&ensp;&ensp;&#124;─projectId | string  |                  |
| &ensp;&ensp;&ensp;&ensp;&#124;─columnId  | string  |                  |

**Request Demo:**

```json
{
  "id": "",
  "projectId": "",
  "typeId": "",
  "reportName": "",
  "reportIssue": "",
  "publish": 0,
  "content": "",
  "createWay": 0,
  "createBy": "",
  "createTime": "",
  "reportExtendVoList": [
    {
      "projectId": "",
      "columnId": ""
    }
  ]
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



##### 批量发布

> BASIC

**Path:** /clb/report/publishBatch

**Method:** GET

> REQUEST

**Query:**

| name | value | required | desc       |
| ---- | ----- | -------- | ---------- |
| ids  |       | YES      | 报告id集合 |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```



------

##### 立即推送

> BASIC

**Path:** /clb/report/push

**Method:** POST

> REQUEST

**Headers:**

| name         | value                             | required | desc |
| ------------ | --------------------------------- | -------- | ---- |
| Content-Type | application/x-www-form-urlencoded | YES      |      |

**Query:**

| name        | value | required | desc   |
| ----------- | ----- | -------- | ------ |
| id          |       | YES      | 报告id |
| emailScope  |       | NO       |        |
| weChatScope |       | NO       |        |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name            | type    | desc               |
| --------------- | ------- | ------------------ |
| success         | boolean | 成功标志           |
| message         | string  | 返回处理消息       |
| code            | integer | 返回代码           |
| result          | object  | 返回数据对象 data  |
| timestamp       | integer | 时间戳             |
| handleMsg       | string  | python接口返回     |
| isHandleSuccess | boolean | python接口返回状态 |
| logs            | string  | python接口返回状态 |
| resultData      | object  | 返回数据对象 data  |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": null,
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": null
}
```

##### 下载报告

> BASIC

**Path:** /clb/report/download

**Method:** GET

> REQUEST

**Query:**

| name | value | required | desc   |
| ---- | ----- | -------- | ------ |
| id   |       | YES      | 报告id |



------

##### 预览

> BASIC

**Path:** /clb/report/preview

**Method:** GET

> REQUEST

**Query:**

| name | value | required | desc   |
| ---- | ----- | -------- | ------ |
| id   |       | YES      | 报告id |









 

