### 设计思想

- 数据动态可配置：通过栏目调整栏目组和栏目门户页面即可生效
- 接口可复用性强：通过传入不同的参数标识资讯类的列表接口进行复用
- 栏目与栏目管理的栏目一 一对应：通过栏目管理可以对门户页面的栏目和栏目组进行增删改

### 接口列表

#### 政策通知

列表

详情（丰富附件链接）

政策类

- 国家政策
- 地方政策
- 行业协会政策
- 项目申报通知
- 活动通知

资讯类

- 政策解读



##### 通过项目获取栏目组列表和栏目列表

- url:{service}:{port}/public-opinion/api/ /channel/clbColumnType/listByProjectId

  **Method:** GET

  > REQUEST

  **Query:**

  | name      | value | required | desc   |
  | --------- | ----- | -------- | ------ |
  | projectId |       | YES      | 项目id |

  

  > RESPONSE

  **Headers:**

  | name         | value                          | required | desc |
  | ------------ | ------------------------------ | -------- | ---- |
  | content-type | application/json;charset=UTF-8 | NO       |      |

  **Body:**

| name                                                         | type    | desc                                                         |
| ------------------------------------------------------------ | ------- | ------------------------------------------------------------ |
| success                                                      | boolean | 成功标志                                                     |
| message                                                      | string  | 返回处理消息                                                 |
| code                                                         | integer | 返回代码                                                     |
| result                                                       | array   | 返回数据对象 data                                            |
| &ensp;&ensp;&#124;─                                          | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─id                            | string  | 主键                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─name                          | string  | 栏目类别名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─createBy                      | string  | 创建人                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─createTime                    | string  | 创建日期                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─updateBy                      | string  | 更新人                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─updateTime                    | string  | 更新日期                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode                    | string  | 所属部门                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─pid                           | string  | 父级节点                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─hasChild                      | string  | 是否有子节点                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─pathIds                       | string  | 全路径                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sort                          | integer | 排序                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─children                      | array   | 下级节点                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id    | string  | 主键                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name  | string  | 栏目类别名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy | string  | 创建人                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime | string  | 创建日期                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy | string  | 更新人                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime | string  | 更新日期                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode | string  | 所属部门                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid   | string  | 父级节点                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild | string  | 是否有子节点                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pathIds | string  | 全路径                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort  | integer | 排序                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children | array   | 下级节点                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─num   | integer | 关联栏目组个数                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type  | string  | 返回信息类别（project：项目 columnGroup：栏目组 column：栏目） |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code  | string  | 编码                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─num                           | integer | 关联栏目组个数                                               |
| &ensp;&ensp;&ensp;&ensp;&#124;─type                          | string  | 返回信息类别（project：项目 columnGroup：栏目组 column：栏目） |
| &ensp;&ensp;&ensp;&ensp;&#124;─code                          | string  | 编码                                                         |
| timestamp                                                    | integer | 时间戳                                                       |

**Response Demo:**

  ```json
  {
    "success": false,
    "message": "",
    "code": 0,
    "result": [
      {
        "id": "",
        "name": "",
        "createBy": "",
        "createTime": "",
        "updateBy": "",
        "updateTime": "",
        "sysOrgCode": "",
        "pid": "",
        "hasChild": "",
        "pathIds": "",
        "sort": 0,
        "children": [
          {
            "id": "",
            "name": "",
            "createBy": "",
            "createTime": "",
            "updateBy": "",
            "updateTime": "",
            "sysOrgCode": "",
            "pid": "",
            "hasChild": "",
            "pathIds": "",
            "sort": 0,
            "children": [],
            "num": 0,
            "type": "",
            "code": ""
          }
        ],
        "num": 0,
        "type": "",
        "code": ""
      }
    ],
    "timestamp": 0
  }
  ```

  

##### 通过栏目组id获取栏目组及栏目树状数据

- url:{service}:{port}/public-opinion/api/datapull/column/treeByColumnGroupIdOrProjectId

  **Method:** GET

  > REQUEST

  **Query:**

  | name | value | required | desc                |
  | ---- | ----- | -------- | ------------------- |
  | id   |       | YES      | id                  |
  | type |       | YES      | 类型[1栏目组 2项目] |

  

  > RESPONSE

  **Headers:**

  | name         | value                          | required | desc |
  | ------------ | ------------------------------ | -------- | ---- |
  | content-type | application/json;charset=UTF-8 | NO       |      |

  **Body:**

  | name                                                         | type    | desc                     |
  | ------------------------------------------------------------ | ------- | ------------------------ |
  | success                                                      | boolean | 成功标志                 |
  | message                                                      | string  | 返回处理消息             |
  | code                                                         | integer | 返回代码                 |
  | result                                                       | object  | 返回数据对象 data        |
  | &ensp;&ensp;&#124;─id                                        | string  | 主键                     |
  | &ensp;&ensp;&#124;─name                                      | string  | 栏目类别名称             |
  | &ensp;&ensp;&#124;─createBy                                  | string  | 创建人                   |
  | &ensp;&ensp;&#124;─createTime                                | string  | 创建日期                 |
  | &ensp;&ensp;&#124;─updateBy                                  | string  | 更新人                   |
  | &ensp;&ensp;&#124;─updateTime                                | string  | 更新日期                 |
  | &ensp;&ensp;&#124;─sysOrgCode                                | string  | 所属部门                 |
  | &ensp;&ensp;&#124;─pid                                       | string  | 父级节点                 |
  | &ensp;&ensp;&#124;─hasChild                                  | string  | 是否有子节点             |
  | &ensp;&ensp;&#124;─pathIds                                   | string  | 全路径                   |
  | &ensp;&ensp;&#124;─sort                                      | integer | 排序                     |
  | &ensp;&ensp;&#124;─code                                      | string  | 编码                     |
  | &ensp;&ensp;&#124;─status                                    | integer | 状态（1启用 0不启用）    |
  | &ensp;&ensp;&#124;─customerId                                | string  | 所属客户                 |
  | &ensp;&ensp;&#124;─projectId                                 | string  | 项目id                   |
  | &ensp;&ensp;&#124;─children                                  | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name              | string  | 栏目类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy          | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime        | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy          | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime        | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode        | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid               | string  | 父级节点                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild          | string  | 是否有子节点             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pathIds           | string  | 全路径                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort              | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code              | string  | 编码                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status            | integer | 状态（1启用 0不启用）    |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId        | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectId         | string  | 项目id                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children          | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─columnList        | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelName | string  | 频道名称                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 频道配置来源             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelGroupIds | string  | 频道组id集合             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelIds | string  | 频道id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectIds | string  | 专题id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionIds | string  | 地域id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseIds | string  | 企业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryIds | string  | 行业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelIds | string  | 标签类别id集合           |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─detailLabelIds | string  | 具体某类标签的id         |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─json | object  | 组合的json               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─displayType | string  | 频道类型                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─explanation | string  | 说明                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relation | string  | 与、或关系(and-与;or-或) |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelType | string  | 标签类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签类别标识             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 状态                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code | string  | code编码                 |
  | &ensp;&ensp;&#124;─columnList                                | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelName       | string  | 频道名称                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source            | string  | 频道配置来源             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelGroupIds   | string  | 频道组id集合             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelIds        | string  | 频道id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectIds        | string  | 专题id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectTypes      | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionIds         | string  | 地域id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionTypes       | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseIds     | string  | 企业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseTypes   | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryIds       | string  | 行业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryTypes     | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelIds          | string  | 标签类别id集合           |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─detailLabelIds    | string  | 具体某类标签的id         |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─json              | object  | 组合的json               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─displayType       | string  | 频道类型                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─explanation       | string  | 说明                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort              | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy          | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime        | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy          | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime        | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode        | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId        | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relation          | string  | 与、或关系(and-与;or-或) |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelType         | string  | 标签类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark         | string  | 标签类别标识             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status            | integer | 状态                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code              | string  | code编码                 |
  | timestamp                                                    | integer | 时间戳                   |
  | handleMsg                                                    | string  | python接口返回           |
  | isHandleSuccess                                              | boolean | python接口返回状态       |
  | logs                                                         | string  | python接口返回状态       |
  | resultData                                                   | object  | 返回数据对象 data        |
  | &ensp;&ensp;&#124;─id                                        | string  | 主键                     |
  | &ensp;&ensp;&#124;─name                                      | string  | 栏目类别名称             |
  | &ensp;&ensp;&#124;─createBy                                  | string  | 创建人                   |
  | &ensp;&ensp;&#124;─createTime                                | string  | 创建日期                 |
  | &ensp;&ensp;&#124;─updateBy                                  | string  | 更新人                   |
  | &ensp;&ensp;&#124;─updateTime                                | string  | 更新日期                 |
  | &ensp;&ensp;&#124;─sysOrgCode                                | string  | 所属部门                 |
  | &ensp;&ensp;&#124;─pid                                       | string  | 父级节点                 |
  | &ensp;&ensp;&#124;─hasChild                                  | string  | 是否有子节点             |
  | &ensp;&ensp;&#124;─pathIds                                   | string  | 全路径                   |
  | &ensp;&ensp;&#124;─sort                                      | integer | 排序                     |
  | &ensp;&ensp;&#124;─code                                      | string  | 编码                     |
  | &ensp;&ensp;&#124;─status                                    | integer | 状态（1启用 0不启用）    |
  | &ensp;&ensp;&#124;─customerId                                | string  | 所属客户                 |
  | &ensp;&ensp;&#124;─projectId                                 | string  | 项目id                   |
  | &ensp;&ensp;&#124;─children                                  | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─name              | string  | 栏目类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy          | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime        | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy          | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime        | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode        | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pid               | string  | 父级节点                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hasChild          | string  | 是否有子节点             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pathIds           | string  | 全路径                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort              | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code              | string  | 编码                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status            | integer | 状态（1启用 0不启用）    |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId        | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectId         | string  | 项目id                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─children          | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─columnList        | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelName | string  | 频道名称                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 频道配置来源             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelGroupIds | string  | 频道组id集合             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelIds | string  | 频道id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectIds | string  | 专题id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionIds | string  | 地域id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseIds | string  | 企业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryIds | string  | 行业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryTypes | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelIds | string  | 标签类别id集合           |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─detailLabelIds | string  | 具体某类标签的id         |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─json | object  | 组合的json               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─displayType | string  | 频道类型                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─explanation | string  | 说明                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relation | string  | 与、或关系(and-与;or-或) |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelType | string  | 标签类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签类别标识             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 状态                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code | string  | code编码                 |
  | &ensp;&ensp;&#124;─columnList                                | array   |                          |
  | &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 主键                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelName       | string  | 频道名称                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source            | string  | 频道配置来源             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelGroupIds   | string  | 频道组id集合             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─channelIds        | string  | 频道id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectIds        | string  | 专题id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectTypes      | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionIds         | string  | 地域id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─regionTypes       | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseIds     | string  | 企业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─enterpriseTypes   | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryIds       | string  | 行业id集合               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─industryTypes     | string  |                          |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelIds          | string  | 标签类别id集合           |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─detailLabelIds    | string  | 具体某类标签的id         |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─json              | object  | 组合的json               |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─displayType       | string  | 频道类型                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─explanation       | string  | 说明                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sort              | integer | 排序                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createBy          | string  | 创建人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createTime        | string  | 创建日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateBy          | string  | 更新人                   |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateTime        | string  | 更新日期                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sysOrgCode        | string  | 所属部门                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customerId        | string  | 所属客户                 |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relation          | string  | 与、或关系(and-与;or-或) |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelType         | string  | 标签类别名称             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark         | string  | 标签类别标识             |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status            | integer | 状态                     |
  | &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─code              | string  | code编码                 |

  **Response Demo:**

  ```json
  {
    "success": false,
    "message": "",
    "code": 0,
    "result": {
      "id": "",
      "name": "",
      "createBy": "",
      "createTime": "",
      "updateBy": "",
      "updateTime": "",
      "sysOrgCode": "",
      "pid": "",
      "hasChild": "",
      "pathIds": "",
      "sort": 0,
      "code": "",
      "status": 0,
      "customerId": "",
      "projectId": "",
      "children": [
        {
          "id": "",
          "name": "",
          "createBy": "",
          "createTime": "",
          "updateBy": "",
          "updateTime": "",
          "sysOrgCode": "",
          "pid": "",
          "hasChild": "",
          "pathIds": "",
          "sort": 0,
          "code": "",
          "status": 0,
          "customerId": "",
          "projectId": "",
          "children": [
            {}
          ],
          "columnList": [
            {
              "id": "",
              "channelName": "",
              "source": "",
              "channelGroupIds": "",
              "channelIds": "",
              "subjectIds": "",
              "subjectTypes": "",
              "regionIds": "",
              "regionTypes": "",
              "enterpriseIds": "",
              "enterpriseTypes": "",
              "industryIds": "",
              "industryTypes": "",
              "labelIds": "",
              "detailLabelIds": "",
              "json": {},
              "displayType": "",
              "explanation": "",
              "sort": 0,
              "createBy": "",
              "createTime": "",
              "updateBy": "",
              "updateTime": "",
              "sysOrgCode": "",
              "customerId": "",
              "relation": "",
              "labelType": "",
              "labelMark": "",
              "status": 0,
              "code": ""
            }
          ]
        }
      ],
      "columnList": [
        {
          "id": "",
          "channelName": "",
          "source": "",
          "channelGroupIds": "",
          "channelIds": "",
          "subjectIds": "",
          "subjectTypes": "",
          "regionIds": "",
          "regionTypes": "",
          "enterpriseIds": "",
          "enterpriseTypes": "",
          "industryIds": "",
          "industryTypes": "",
          "labelIds": "",
          "detailLabelIds": "",
          "json": {},
          "displayType": "",
          "explanation": "",
          "sort": 0,
          "createBy": "",
          "createTime": "",
          "updateBy": "",
          "updateTime": "",
          "sysOrgCode": "",
          "customerId": "",
          "relation": "",
          "labelType": "",
          "labelMark": "",
          "status": 0,
          "code": ""
        }
      ]
    },
    "timestamp": 0,
    "handleMsg": "",
    "isHandleSuccess": false,
    "logs": "",
    "resultData": {
      "id": "",
      "name": "",
      "createBy": "",
      "createTime": "",
      "updateBy": "",
      "updateTime": "",
      "sysOrgCode": "",
      "pid": "",
      "hasChild": "",
      "pathIds": "",
      "sort": 0,
      "code": "",
      "status": 0,
      "customerId": "",
      "projectId": "",
      "children": [
        {
          "id": "",
          "name": "",
          "createBy": "",
          "createTime": "",
          "updateBy": "",
          "updateTime": "",
          "sysOrgCode": "",
          "pid": "",
          "hasChild": "",
          "pathIds": "",
          "sort": 0,
          "code": "",
          "status": 0,
          "customerId": "",
          "projectId": "",
          "children": [
            {}
          ],
          "columnList": [
            {
              "id": "",
              "channelName": "",
              "source": "",
              "channelGroupIds": "",
              "channelIds": "",
              "subjectIds": "",
              "subjectTypes": "",
              "regionIds": "",
              "regionTypes": "",
              "enterpriseIds": "",
              "enterpriseTypes": "",
              "industryIds": "",
              "industryTypes": "",
              "labelIds": "",
              "detailLabelIds": "",
              "json": {},
              "displayType": "",
              "explanation": "",
              "sort": 0,
              "createBy": "",
              "createTime": "",
              "updateBy": "",
              "updateTime": "",
              "sysOrgCode": "",
              "customerId": "",
              "relation": "",
              "labelType": "",
              "labelMark": "",
              "status": 0,
              "code": ""
            }
          ]
        }
      ],
      "columnList": [
        {
          "id": "",
          "channelName": "",
          "source": "",
          "channelGroupIds": "",
          "channelIds": "",
          "subjectIds": "",
          "subjectTypes": "",
          "regionIds": "",
          "regionTypes": "",
          "enterpriseIds": "",
          "enterpriseTypes": "",
          "industryIds": "",
          "industryTypes": "",
          "labelIds": "",
          "detailLabelIds": "",
          "json": {},
          "displayType": "",
          "explanation": "",
          "sort": 0,
          "createBy": "",
          "createTime": "",
          "updateBy": "",
          "updateTime": "",
          "sysOrgCode": "",
          "customerId": "",
          "relation": "",
          "labelType": "",
          "labelMark": "",
          "status": 0,
          "code": ""
        }
      ]
    }
  }
  ```

##### 通过栏目id获取资讯分页列表

**url**:{service}:{port}/public-opinion/datapull/column/queryInfoList

**Method:** POST

> REQUEST

**Headers:**

| name         | value            | required | desc |
| ------------ | ---------------- | -------- | ---- |
| Content-Type | application/json | YES      |      |

**Request Body:**

| name                                          | type    | desc                                                         |
| --------------------------------------------- | ------- | ------------------------------------------------------------ |
| type                                          | int     | 类型1：政策2：项目申报通知3：活动通知                        |
| subjectId                                     | string  | 专题id                                                       |
| url                                           | string  | 文章链接                                                     |
| title                                         | string  | 专题标题                                                     |
| summary                                       | string  | 专题摘要                                                     |
| content                                       | string  | 内容                                                         |
| author                                        | string  | 作者                                                         |
| publishDate                                   | string  | 发布时间                                                     |
| origin                                        | string  | 来源                                                         |
| score                                         | string  | 得分                                                         |
| enterpriseName                                | string  | 企业名称                                                     |
| InfoType                                      | string  | 信息类型                                                     |
| libraryType                                   | string  | 专题库类型                                                   |
| type                                          | integer | 置顶标识（0取消置顶 1置顶）                                  |
| sourceAddress                                 | string  |                                                              |
| startTime                                     | string  | 开始时间                                                     |
| endTime                                       | string  | 结束时间                                                     |
| classificationType                            | integer | 专题库类型(1：政策；2：领导讲话；3：专家观点；4：企业案例)   |
| checkStatusList                               | array   | 审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0) |
| &ensp;&ensp;&#124;─                           | integer |                                                              |
| checkStatus                                   | integer |                                                              |
| deleteFlag                                    | integer | 删除标记(1:删除；0:保留)                                     |
| userId                                        | string  | 用户id                                                       |
| columnId                                      | string  | 项目id、栏目id、栏目组id                                     |
| video                                         | string  | 是否音频、视频                                               |
| searchInfo                                    | string  | 搜索内容                                                     |
| column                                        | string  | 排序的列 ["score"(相关性)，"publishDate"(发布时间)]          |
| order                                         | string  | 排序字段  [desc\|asc]默认desc                                |
| pageNo                                        | integer | 页码                                                         |
| pageSize                                      | integer | 页大小                                                       |
| ynAll                                         | string  | 是否所有                                                     |
| ynChannel                                     | string  | 是否是栏目                                                   |
| ynProject                                     | string  | 是否是项目                                                   |
| channelId                                     | string  | 筛选的栏目id                                                 |
| labels                                        | array   | 标签                                                         |
| &ensp;&ensp;&#124;─                           | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─hitRemarks     | string  | 命中标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─labelMark      | string  | 标签标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─labelRemarks   | string  | 标签备注                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─projectLabelId | string  | 项目标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─relationId     | string  | 关联标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─relationName   | string  | 关联标签名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─status         | integer | 审核状态                                                     |
| searchScope                                   | integer | 关键词检索范围 [1标题  2正文 3 全部]                         |
| searchAccuracy                                | string  | 精确度["精确"\| --]                                          |

**Request Demo:**

```json
{
  "id": "",
  "subjectId": "",
  "url": "",
  "title": "",
  "summary": "",
  "content": "",
  "author": "",
  "publishDate": "",
  "origin": "",
  "score": "",
  "enterpriseName": "",
  "InfoType": "",
  "libraryType": "",
  "type": 0,
  "sourceAddress": "",
  "startTime": "",
  "endTime": "",
  "classificationType": 0,
  "checkStatusList": [
    0
  ],
  "checkStatus": 0,
  "deleteFlag": 0,
  "userId": "",
  "columnId": "",
  "video": "",
  "searchInfo": "",
  "column": "",
  "order": "",
  "pageNo": 0,
  "pageSize": 0,
  "ynAll": "",
  "ynChannel": "",
  "ynProject": "",
  "channelId": "",
  "labels": [
    {
      "hitRemarks": "",
      "labelMark": "",
      "labelRemarks": "",
      "projectLabelId": "",
      "relationId": "",
      "relationName": "",
      "status": 0
    }
  ],
  "searchScope": 0,
  "searchAccuracy": ""
}
```



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                         | type    | desc                                                         |
| ------------------------------------------------------------ | ------- | ------------------------------------------------------------ |
| success                                                      | boolean | 成功标志                                                     |
| message                                                      | string  | 返回处理消息                                                 |
| code                                                         | integer | 返回代码                                                     |
| result                                                       | object  | 返回数据对象 data                                            |
| &ensp;&ensp;&#124;─total                                     | string  | 总条数                                                       |
| &ensp;&ensp;&#124;─size                                      | string  | 页容量                                                       |
| &ensp;&ensp;&#124;─current                                   | string  | 当前页                                                       |
| &ensp;&ensp;&#124;─orders                                    | string  |                                                              |
| &ensp;&ensp;&#124;─optimizeCountSql                          | string  |                                                              |
| &ensp;&ensp;&#124;─hitCount                                  | string  |                                                              |
| &ensp;&ensp;&#124;─countId                                   | string  |                                                              |
| &ensp;&ensp;&#124;─maxLimit                                  | string  |                                                              |
| &ensp;&ensp;&#124;─searchCount                               | string  |                                                              |
| &ensp;&ensp;&#124;─pages                                     | string  |                                                              |
| &ensp;&ensp;&#124;─record                                    | array   |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─author            | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─authorRaw         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─content           | string  | 正文                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentRaw        | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag    | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentWithTagRaw | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createDate        | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sid               | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─lang              | string  | 语言                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─langRaw           | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─origin            | string  | 来源（信息来源）                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originRaw         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─publishDate       | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originalTime      | string  | 原始时间（网页上，没有解析之前的时间）                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress     | string  | 发布地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─summary           | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─summaryRaw        | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─keyWords          | string  | 关键词                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─title             | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─titleRaw          | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source            | string  | 采集来源（如通用、定制、微信公众号等）                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type              | string  | 附加字段                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labels            | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hitRemarks | string  | 命中标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelRemarks | string  | 标签备注                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectLabelId | string  | 项目标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationId | string  | 关联标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationName | string  | 关联标签名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 审核状态                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─downLoadUrl       | string  | 视频下载链接                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoUrl          | string  | 视频链接（原链接 网页版）                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoPhoneUrl     | string  | 视频链接（原链接 手机版）                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoTime         | integer | 视频时长                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoImg          | string  | 视频第一帧图片                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customLabel       | array   | 自定义标签                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─score             | number  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─classificationType | integer | 专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─topNum            | integer | 置顶排位(默认为0)                                            |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag        | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectId         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─checkStatus       | integer | 审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─readNum           | integer | 阅读数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ynCollect         | boolean | 是否收藏                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─repeatId          | string  | 重复id                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─flag              | string  | （1：主条目  0：非主条目）                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─masterEntryId     | string  | 关联的主条目id                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originalId        | string  | 原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─screenShotImg     | string  | 快照地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateDate        | string  | 资讯更新时间                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─infoSourceType    | string  | 信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它） |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataType          | string  | 数据类型 qbyw:情报要闻 qbnc:情报内参                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─abiUrl            | string  | abi报表地址                                                  |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─abiId             | string  | abi报表id                                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─programaIds       | array   | 栏目code列表                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─databaseIds       | array   | 数据库code列表                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─isRisk            | integer | 是否风险                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─riskTypes         | array   | 风险类型                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds     | array   | 资讯关联的附件id                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─AttachmentInfos   | array   | 附件集合                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentName | string  | 附件名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─group | string  | 附件组                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentFullPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentId | string  | 附件对应的id                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─category | string  | 扩展名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─fileSize | string  | 附件大小                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pageSize | integer | 总页数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 来源                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─processDate       | string  | 数据入专题库时间                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─likesNum          | integer | 点赞数字                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentNo         | string  | 法规号                                                       |
| timestamp                                                    | integer | 时间戳                                                       |
| handleMsg                                                    | string  | python接口返回                                               |
| isHandleSuccess                                              | boolean | python接口返回状态                                           |
| logs                                                         | string  | python接口返回状态                                           |
| resultData                                                   | object  | 返回数据对象 data                                            |
| &ensp;&ensp;&#124;─total                                     | string  | 总条数                                                       |
| &ensp;&ensp;&#124;─size                                      | string  | 页容量                                                       |
| &ensp;&ensp;&#124;─current                                   | string  | 当前页                                                       |
| &ensp;&ensp;&#124;─orders                                    | string  |                                                              |
| &ensp;&ensp;&#124;─optimizeCountSql                          | string  |                                                              |
| &ensp;&ensp;&#124;─hitCount                                  | string  |                                                              |
| &ensp;&ensp;&#124;─countId                                   | string  |                                                              |
| &ensp;&ensp;&#124;─maxLimit                                  | string  |                                                              |
| &ensp;&ensp;&#124;─searchCount                               | string  |                                                              |
| &ensp;&ensp;&#124;─pages                                     | string  |                                                              |
| &ensp;&ensp;&#124;─record                                    | array   |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─                              | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─author            | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─authorRaw         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─content           | string  | 正文                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentRaw        | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag    | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentWithTagRaw | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─createDate        | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─id                | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sid               | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─lang              | string  | 语言                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─langRaw           | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─origin            | string  | 来源（信息来源）                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originRaw         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─publishDate       | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originalTime      | string  | 原始时间（网页上，没有解析之前的时间）                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress     | string  | 发布地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─summary           | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─summaryRaw        | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─keyWords          | string  | 关键词                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─title             | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─titleRaw          | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source            | string  | 采集来源（如通用、定制、微信公众号等）                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─type              | string  | 附加字段                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labels            | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hitRemarks | string  | 命中标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelRemarks | string  | 标签备注                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectLabelId | string  | 项目标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationId | string  | 关联标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationName | string  | 关联标签名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 审核状态                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─downLoadUrl       | string  | 视频下载链接                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoUrl          | string  | 视频链接（原链接 网页版）                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoPhoneUrl     | string  | 视频链接（原链接 手机版）                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoTime         | integer | 视频时长                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─videoImg          | string  | 视频第一帧图片                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─customLabel       | array   | 自定义标签                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─score             | number  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─classificationType | integer | 专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─topNum            | integer | 置顶排位(默认为0)                                            |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag        | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─subjectId         | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─checkStatus       | integer | 审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─readNum           | integer | 阅读数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─ynCollect         | boolean | 是否收藏                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─repeatId          | string  | 重复id                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─flag              | string  | （1：主条目  0：非主条目）                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─masterEntryId     | string  | 关联的主条目id                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─originalId        | string  | 原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系) |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─screenShotImg     | string  | 快照地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─updateDate        | string  | 资讯更新时间                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─infoSourceType    | string  | 信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它） |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─dataType          | string  | 数据类型 qbyw:情报要闻 qbnc:情报内参                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─abiUrl            | string  | abi报表地址                                                  |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─abiId             | string  | abi报表id                                                    |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─programaIds       | array   | 栏目code列表                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─databaseIds       | array   | 数据库code列表                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─isRisk            | integer | 是否风险                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─riskTypes         | array   | 风险类型                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds     | array   | 资讯关联的附件id                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─AttachmentInfos   | array   | 附件集合                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─      | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentName | string  | 附件名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─group | string  | 附件组                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentFullPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentId | string  | 附件对应的id                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─category | string  | 扩展名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─fileSize | string  | 附件大小                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pageSize | integer | 总页数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 来源                                                         |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─processDate       | string  | 数据入专题库时间                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─likesNum          | integer | 点赞数字                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─contentNo         | string  | 法规号                                                       |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "total": "",
    "size": "",
    "current": "",
    "orders": "",
    "optimizeCountSql": "",
    "hitCount": "",
    "countId": "",
    "maxLimit": "",
    "searchCount": "",
    "pages": "",
    "record": [
      {
        "author": "",
        "authorRaw": "",
        "content": "",
        "contentRaw": "",
        "contentWithTag": "",
        "contentWithTagRaw": "",
        "createDate": "",
        "id": "",
        "sid": "",
        "lang": "",
        "langRaw": "",
        "origin": "",
        "originRaw": "",
        "publishDate": "",
        "originalTime": "",
        "sourceAddress": "",
        "summary": "",
        "summaryRaw": "",
        "keyWords": "",
        "title": "",
        "titleRaw": "",
        "source": "",
        "type": "",
        "labels": [
          {
            "hitRemarks": "",
            "labelMark": "",
            "labelRemarks": "",
            "projectLabelId": "",
            "relationId": "",
            "relationName": "",
            "status": 0
          }
        ],
        "downLoadUrl": "",
        "videoUrl": "",
        "videoPhoneUrl": "",
        "videoTime": 0,
        "videoImg": "",
        "customLabel": [
          ""
        ],
        "score": 0.0,
        "classificationType": 0,
        "topNum": 0,
        "deleteFlag": 0,
        "subjectId": "",
        "checkStatus": 0,
        "readNum": 0,
        "ynCollect": false,
        "repeatId": "",
        "flag": "",
        "masterEntryId": "",
        "originalId": "",
        "screenShotImg": "",
        "updateDate": "",
        "infoSourceType": "",
        "dataType": "",
        "abiUrl": "",
        "abiId": "",
        "programaIds": [
          ""
        ],
        "databaseIds": [
          ""
        ],
        "isRisk": 0,
        "riskTypes": [
          ""
        ],
        "attachmentIds": [
          ""
        ],
        "AttachmentInfos": [
          {
            "attachmentName": "",
            "attachmentPath": "",
            "group": "",
            "attachmentFullPath": "",
            "attachmentId": "",
            "category": "",
            "fileSize": "",
            "pageSize": 0,
            "source": ""
          }
        ],
        "processDate": "",
        "likesNum": 0,
        "contentNo": ""
      }
    ]
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "total": "",
    "size": "",
    "current": "",
    "orders": "",
    "optimizeCountSql": "",
    "hitCount": "",
    "countId": "",
    "maxLimit": "",
    "searchCount": "",
    "pages": "",
    "record": [
      {
        "author": "",
        "authorRaw": "",
        "content": "",
        "contentRaw": "",
        "contentWithTag": "",
        "contentWithTagRaw": "",
        "createDate": "",
        "id": "",
        "sid": "",
        "lang": "",
        "langRaw": "",
        "origin": "",
        "originRaw": "",
        "publishDate": "",
        "originalTime": "",
        "sourceAddress": "",
        "summary": "",
        "summaryRaw": "",
        "keyWords": "",
        "title": "",
        "titleRaw": "",
        "source": "",
        "type": "",
        "labels": [
          {
            "hitRemarks": "",
            "labelMark": "",
            "labelRemarks": "",
            "projectLabelId": "",
            "relationId": "",
            "relationName": "",
            "status": 0
          }
        ],
        "downLoadUrl": "",
        "videoUrl": "",
        "videoPhoneUrl": "",
        "videoTime": 0,
        "videoImg": "",
        "customLabel": [
          ""
        ],
        "score": 0.0,
        "classificationType": 0,
        "topNum": 0,
        "deleteFlag": 0,
        "subjectId": "",
        "checkStatus": 0,
        "readNum": 0,
        "ynCollect": false,
        "repeatId": "",
        "flag": "",
        "masterEntryId": "",
        "originalId": "",
        "screenShotImg": "",
        "updateDate": "",
        "infoSourceType": "",
        "dataType": "",
        "abiUrl": "",
        "abiId": "",
        "programaIds": [
          ""
        ],
        "databaseIds": [
          ""
        ],
        "isRisk": 0,
        "riskTypes": [
          ""
        ],
        "attachmentIds": [
          ""
        ],
        "AttachmentInfos": [
          {
            "attachmentName": "",
            "attachmentPath": "",
            "group": "",
            "attachmentFullPath": "",
            "attachmentId": "",
            "category": "",
            "fileSize": "",
            "pageSize": 0,
            "source": ""
          }
        ],
        "processDate": "",
        "likesNum": 0,
        "contentNo": ""
      }
    ]
  }
}
```

##### 资讯政策详情接口

**url**:{service}:{port}/datapull/column/getArticleById

**Method:** GET

> REQUEST

**Query:**

| name | value | required | desc                                  |
| ---- | ----- | -------- | ------------------------------------- |
| id   |       | YES      | id                                    |
| type |       | YES      | 类型1：政策2：项目申报通知3：活动通知 |



> RESPONSE

**Headers:**

| name         | value                          | required | desc |
| ------------ | ------------------------------ | -------- | ---- |
| content-type | application/json;charset=UTF-8 | NO       |      |

**Body:**

| name                                                         | type    | desc                                                         |
| ------------------------------------------------------------ | ------- | ------------------------------------------------------------ |
| success                                                      | boolean | 成功标志                                                     |
| message                                                      | string  | 返回处理消息                                                 |
| code                                                         | integer | 返回代码                                                     |
| result                                                       | object  | 返回数据对象 data                                            |
| &ensp;&ensp;&#124;─policyInfo                                | object  | 政策                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds                 | string  | 附件id(存储在文件服务器的id)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─author                        | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─content                       | string  | 正文（不带标签）                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag                | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─createDate                    | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─id                            | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sid                           | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─origin                        | string  | 来源（政策发布机关）                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─organ                         | string  | 来源  （政策发文机关）                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─publishDate                   | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress                 | string  | 原文链接                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─summary                       | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─title                         | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─labels                        | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag                    | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─topicClassification           | string  | 政策文件分类                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─issuedNumber                  | string  | 政策文件分类                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─writtenDate                   | string  | 成文时间                                                     |
| &ensp;&ensp;&#124;─specialInformation                        | object  | 资讯                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─author                        | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─authorRaw                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─content                       | string  | 正文                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentRaw                    | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag                | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTagRaw             | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─createDate                    | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─id                            | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sid                           | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─lang                          | string  | 语言                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─langRaw                       | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─origin                        | string  | 来源（信息来源）                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─originRaw                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─publishDate                   | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─originalTime                  | string  | 原始时间（网页上，没有解析之前的时间）                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress                 | string  | 发布地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─summary                       | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─summaryRaw                    | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─keyWords                      | string  | 关键词                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─title                         | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─titleRaw                      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─source                        | string  | 采集来源（如通用、定制、微信公众号等）                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─type                          | string  | 附加字段                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─labels                        | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hitRemarks | string  | 命中标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelRemarks | string  | 标签备注                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectLabelId | string  | 项目标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationId | string  | 关联标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationName | string  | 关联标签名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 审核状态                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─downLoadUrl                   | string  | 视频下载链接                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoUrl                      | string  | 视频链接（原链接 网页版）                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoPhoneUrl                 | string  | 视频链接（原链接 手机版）                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoTime                     | integer | 视频时长                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoImg                      | string  | 视频第一帧图片                                               |
| &ensp;&ensp;&ensp;&ensp;&#124;─customLabel                   | array   | 自定义标签                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─score                         | number  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─classificationType            | integer | 专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例) |
| &ensp;&ensp;&ensp;&ensp;&#124;─topNum                        | integer | 置顶排位(默认为0)                                            |
| &ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag                    | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─subjectId                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─checkStatus                   | integer | 审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0) |
| &ensp;&ensp;&ensp;&ensp;&#124;─readNum                       | integer | 阅读数                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─ynCollect                     | boolean | 是否收藏                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─repeatId                      | string  | 重复id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─flag                          | string  | （1：主条目  0：非主条目）                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─masterEntryId                 | string  | 关联的主条目id                                               |
| &ensp;&ensp;&ensp;&ensp;&#124;─originalId                    | string  | 原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系) |
| &ensp;&ensp;&ensp;&ensp;&#124;─screenShotImg                 | string  | 快照地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─updateDate                    | string  | 资讯更新时间                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─infoSourceType                | string  | 信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它） |
| &ensp;&ensp;&ensp;&ensp;&#124;─dataType                      | string  | 数据类型 qbyw:情报要闻 qbnc:情报内参                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─abiUrl                        | string  | abi报表地址                                                  |
| &ensp;&ensp;&ensp;&ensp;&#124;─abiId                         | string  | abi报表id                                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─programaIds                   | array   | 栏目code列表                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─databaseIds                   | array   | 数据库code列表                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─isRisk                        | integer | 是否风险                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─riskTypes                     | array   | 风险类型                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds                 | array   | 资讯关联的附件id                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─AttachmentInfos               | array   | 附件集合                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentName | string  | 附件名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─group | string  | 附件组                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentFullPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentId | string  | 附件对应的id                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─category | string  | 扩展名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─fileSize | string  | 附件大小                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pageSize | integer | 总页数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 来源                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─processDate                   | string  | 数据入专题库时间                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─likesNum                      | integer | 点赞数字                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentNo                     | string  | 法规号                                                       |
| timestamp                                                    | integer | 时间戳                                                       |
| handleMsg                                                    | string  | python接口返回                                               |
| isHandleSuccess                                              | boolean | python接口返回状态                                           |
| logs                                                         | string  | python接口返回状态                                           |
| resultData                                                   | object  | 返回数据对象 data                                            |
| &ensp;&ensp;&#124;─policyInfo                                | object  | 政策                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds                 | string  | 附件id(存储在文件服务器的id)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─author                        | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─content                       | string  | 正文（不带标签）                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag                | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─createDate                    | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─id                            | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sid                           | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─origin                        | string  | 来源（政策发布机关）                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─organ                         | string  | 来源  （政策发文机关）                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─publishDate                   | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress                 | string  | 原文链接                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─summary                       | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─title                         | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─labels                        | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag                    | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─topicClassification           | string  | 政策文件分类                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─issuedNumber                  | string  | 政策文件分类                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─writtenDate                   | string  | 成文时间                                                     |
| &ensp;&ensp;&#124;─specialInformation                        | object  | 资讯                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─author                        | string  | 说明：...Raw 表示原文，即原语言                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─authorRaw                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─content                       | string  | 正文                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentRaw                    | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTag                | string  | 带标签正文                                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentWithTagRaw             | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─createDate                    | string  | 入库时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─id                            | string  | 信息id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sid                           | string  | 信息来源id(信息源或者关键词)                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─lang                          | string  | 语言                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─langRaw                       | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─origin                        | string  | 来源（信息来源）                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─originRaw                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─publishDate                   | string  | 发布时间                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─originalTime                  | string  | 原始时间（网页上，没有解析之前的时间）                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─sourceAddress                 | string  | 发布地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─summary                       | string  | 摘要                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─summaryRaw                    | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─keyWords                      | string  | 关键词                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─title                         | string  | 标题                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─titleRaw                      | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─source                        | string  | 采集来源（如通用、定制、微信公众号等）                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─type                          | string  | 附加字段                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─labels                        | array   | 标签信息                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─hitRemarks | string  | 命中标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelMark | string  | 标签标识                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─labelRemarks | string  | 标签备注                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─projectLabelId | string  | 项目标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationId | string  | 关联标签id                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─relationName | string  | 关联标签名称                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─status | integer | 审核状态                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─downLoadUrl                   | string  | 视频下载链接                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoUrl                      | string  | 视频链接（原链接 网页版）                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoPhoneUrl                 | string  | 视频链接（原链接 手机版）                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoTime                     | integer | 视频时长                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─videoImg                      | string  | 视频第一帧图片                                               |
| &ensp;&ensp;&ensp;&ensp;&#124;─customLabel                   | array   | 自定义标签                                                   |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─score                         | number  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─classificationType            | integer | 专题库类型(0: 其它 1：政策；2：领导讲话；3：专家观点；4：企业案例) |
| &ensp;&ensp;&ensp;&ensp;&#124;─topNum                        | integer | 置顶排位(默认为0)                                            |
| &ensp;&ensp;&ensp;&ensp;&#124;─deleteFlag                    | integer | 删除标记(1:删除；0:保留)                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─subjectId                     | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─checkStatus                   | integer | 审核操作(0：未审核  1：审核通过  2：审核未通过  3：暂定  默认值为0) |
| &ensp;&ensp;&ensp;&ensp;&#124;─readNum                       | integer | 阅读数                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─ynCollect                     | boolean | 是否收藏                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─repeatId                      | string  | 重复id                                                       |
| &ensp;&ensp;&ensp;&ensp;&#124;─flag                          | string  | （1：主条目  0：非主条目）                                   |
| &ensp;&ensp;&ensp;&ensp;&#124;─masterEntryId                 | string  | 关联的主条目id                                               |
| &ensp;&ensp;&ensp;&ensp;&#124;─originalId                    | string  | 原始id(去重服务生成的id,因为一条信息可以属于多个专题，原始id会发生改变，所以存储一个原始id,找寻对应关系) |
| &ensp;&ensp;&ensp;&ensp;&#124;─screenShotImg                 | string  | 快照地址                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─updateDate                    | string  | 资讯更新时间                                                 |
| &ensp;&ensp;&ensp;&ensp;&#124;─infoSourceType                | string  | 信息类别（1：报刊  2：博客  3：客户端  4：论坛  5：视频  6：外媒  7：网站  8：微博  9：微信  10：新闻  11：政务  12：其它） |
| &ensp;&ensp;&ensp;&ensp;&#124;─dataType                      | string  | 数据类型 qbyw:情报要闻 qbnc:情报内参                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─abiUrl                        | string  | abi报表地址                                                  |
| &ensp;&ensp;&ensp;&ensp;&#124;─abiId                         | string  | abi报表id                                                    |
| &ensp;&ensp;&ensp;&ensp;&#124;─programaIds                   | array   | 栏目code列表                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─databaseIds                   | array   | 数据库code列表                                               |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─isRisk                        | integer | 是否风险                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─riskTypes                     | array   | 风险类型                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─attachmentIds                 | array   | 资讯关联的附件id                                             |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | string  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&#124;─AttachmentInfos               | array   | 附件集合                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─                  | object  |                                                              |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentName | string  | 附件名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─group | string  | 附件组                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentFullPath | string  | 附件相对地址                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─attachmentId | string  | 附件对应的id                                                 |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─category | string  | 扩展名称                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─fileSize | string  | 附件大小                                                     |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─pageSize | integer | 总页数                                                       |
| &ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&ensp;&#124;─source | string  | 来源                                                         |
| &ensp;&ensp;&ensp;&ensp;&#124;─processDate                   | string  | 数据入专题库时间                                             |
| &ensp;&ensp;&ensp;&ensp;&#124;─likesNum                      | integer | 点赞数字                                                     |
| &ensp;&ensp;&ensp;&ensp;&#124;─contentNo                     | string  | 法规号                                                       |

**Response Demo:**

```json
{
  "success": false,
  "message": "",
  "code": 0,
  "result": {
    "policyInfo": {
      "attachmentIds": "",
      "author": "",
      "content": "",
      "contentWithTag": "",
      "createDate": "",
      "id": "",
      "sid": "",
      "origin": "",
      "organ": "",
      "publishDate": "",
      "sourceAddress": "",
      "summary": "",
      "title": "",
      "labels": [
        {}
      ],
      "deleteFlag": 0,
      "topicClassification": "",
      "issuedNumber": "",
      "writtenDate": ""
    },
    "specialInformation": {
      "author": "",
      "authorRaw": "",
      "content": "",
      "contentRaw": "",
      "contentWithTag": "",
      "contentWithTagRaw": "",
      "createDate": "",
      "id": "",
      "sid": "",
      "lang": "",
      "langRaw": "",
      "origin": "",
      "originRaw": "",
      "publishDate": "",
      "originalTime": "",
      "sourceAddress": "",
      "summary": "",
      "summaryRaw": "",
      "keyWords": "",
      "title": "",
      "titleRaw": "",
      "source": "",
      "type": "",
      "labels": [
        {
          "hitRemarks": "",
          "labelMark": "",
          "labelRemarks": "",
          "projectLabelId": "",
          "relationId": "",
          "relationName": "",
          "status": 0
        }
      ],
      "downLoadUrl": "",
      "videoUrl": "",
      "videoPhoneUrl": "",
      "videoTime": 0,
      "videoImg": "",
      "customLabel": [
        ""
      ],
      "score": 0.0,
      "classificationType": 0,
      "topNum": 0,
      "deleteFlag": 0,
      "subjectId": "",
      "checkStatus": 0,
      "readNum": 0,
      "ynCollect": false,
      "repeatId": "",
      "flag": "",
      "masterEntryId": "",
      "originalId": "",
      "screenShotImg": "",
      "updateDate": "",
      "infoSourceType": "",
      "dataType": "",
      "abiUrl": "",
      "abiId": "",
      "programaIds": [
        ""
      ],
      "databaseIds": [
        ""
      ],
      "isRisk": 0,
      "riskTypes": [
        ""
      ],
      "attachmentIds": [
        ""
      ],
      "AttachmentInfos": [
        {
          "attachmentName": "",
          "attachmentPath": "",
          "group": "",
          "attachmentFullPath": "",
          "attachmentId": "",
          "category": "",
          "fileSize": "",
          "pageSize": 0,
          "source": ""
        }
      ],
      "processDate": "",
      "likesNum": 0,
      "contentNo": ""
    }
  },
  "timestamp": 0,
  "handleMsg": "",
  "isHandleSuccess": false,
  "logs": "",
  "resultData": {
    "policyInfo": {
      "attachmentIds": "",
      "author": "",
      "content": "",
      "contentWithTag": "",
      "createDate": "",
      "id": "",
      "sid": "",
      "origin": "",
      "organ": "",
      "publishDate": "",
      "sourceAddress": "",
      "summary": "",
      "title": "",
      "labels": [
        {}
      ],
      "deleteFlag": 0,
      "topicClassification": "",
      "issuedNumber": "",
      "writtenDate": ""
    },
    "specialInformation": {
      "author": "",
      "authorRaw": "",
      "content": "",
      "contentRaw": "",
      "contentWithTag": "",
      "contentWithTagRaw": "",
      "createDate": "",
      "id": "",
      "sid": "",
      "lang": "",
      "langRaw": "",
      "origin": "",
      "originRaw": "",
      "publishDate": "",
      "originalTime": "",
      "sourceAddress": "",
      "summary": "",
      "summaryRaw": "",
      "keyWords": "",
      "title": "",
      "titleRaw": "",
      "source": "",
      "type": "",
      "labels": [
        {
          "hitRemarks": "",
          "labelMark": "",
          "labelRemarks": "",
          "projectLabelId": "",
          "relationId": "",
          "relationName": "",
          "status": 0
        }
      ],
      "downLoadUrl": "",
      "videoUrl": "",
      "videoPhoneUrl": "",
      "videoTime": 0,
      "videoImg": "",
      "customLabel": [
        ""
      ],
      "score": 0.0,
      "classificationType": 0,
      "topNum": 0,
      "deleteFlag": 0,
      "subjectId": "",
      "checkStatus": 0,
      "readNum": 0,
      "ynCollect": false,
      "repeatId": "",
      "flag": "",
      "masterEntryId": "",
      "originalId": "",
      "screenShotImg": "",
      "updateDate": "",
      "infoSourceType": "",
      "dataType": "",
      "abiUrl": "",
      "abiId": "",
      "programaIds": [
        ""
      ],
      "databaseIds": [
        ""
      ],
      "isRisk": 0,
      "riskTypes": [
        ""
      ],
      "attachmentIds": [
        ""
      ],
      "AttachmentInfos": [
        {
          "attachmentName": "",
          "attachmentPath": "",
          "group": "",
          "attachmentFullPath": "",
          "attachmentId": "",
          "category": "",
          "fileSize": "",
          "pageSize": 0,
          "source": ""
        }
      ],
      "processDate": "",
      "likesNum": 0,
      "contentNo": ""
    }
  }
}
```



