package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.clb.common.model.task.dto.titr.KeyWordsDTO;
import com.zzsn.event.vo.SubjectKeywordsMap;

/**
 * @Description: 专题关键词关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
public interface ISubjectKeywordsMapService extends IService<SubjectKeywordsMap> {
    /**
     * 根据专题id删除关联数据
     */
    void delete(String subjectId);

    /**
     * 查询这个词组绑定的专题的最小时间
     * @param keyWordsId
     * @return
     */
    KeyWordsDTO selectMinByKeyWordsId(String keyWordsId);

    /**
     * 查询这个词组绑定的专题时间为空的个数
     * @param keyWordsId
     * @return
     */
    int selectCountByKeyWordsId(String keyWordsId);

    /**
     * 查询这个词组绑定的专题结束的最大时间
     * @param keyWordsId
     * @return
     */
    KeyWordsDTO selectMaxByKeyWordsId(String keyWordsId);


}
