package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件抽取任务表
* @TableName event_extract_task
*/
@Data
@TableName("event_extract_task")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="event_extract_task对象", description="挖掘事件任务")
public class EventExtractTask implements Serializable {

    /**
    * 任务id
    */
    @TableId(value = "id",type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 任务名称
    */
    @TableField("task_name")
    private String taskName;
    /**
    * 项目id
    */
    @TableField("project_id")
    private String projectId;
    /**
    * 栏目id，多个用逗号隔开
    */
    @TableField("column_id")
    private String columnId;
    /**
    * 数据状态(0：未审核 1：审核通过 3：暂定 4：删除)
    */
    @TableField("data_status")
    private Integer dataStatus;
    /**
    * 数据开始时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("start_time")
    private Date startTime;
    /**
    * 数据结束时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("end_time")
    private Date endTime;
    /**
    * 任务状态(1-开启;0-关闭)
    */
    @TableField("task_status")
    private Integer taskStatus;
    /**
    * 最近一次执行时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("last_update_time")
    private Date lastUpdateTime;
    /**
     * 删除状态(1-删除;0-未删除)
     */
    @TableField("delete_status")
    private Integer deleteStatus;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @TableField("create_time")
    private Date createTime;
    /**
    * 创建人
    */
    @TableField("create_by")
    private String createBy;
}
