package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.InfoSourceMain;
import com.zzsn.event.entity.InfoSourceMainGroup;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import com.zzsn.event.vo.InfoSourceVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description: 信息源组表
 * @Author: jeecg-boot
 * @Date: 2021-11-25
 * @Version: V1.0
 */
@Mapper
public interface InfoSourceMainGroupMapper extends BaseMapper<InfoSourceMainGroup> {
    List<InfoSourceMainGroupPage> listByTypeId(@Param("list") List<String> list, @Param("status") int status);

    Integer countListByTypeAndIdList(@Param("finalIdList") List<String> finalIdList, @Param("status") String status);

    List<InfoSourceMainGroupPage> pageList(@Param("infoSourceMainGroup") InfoSourceMainGroup infoSourceMainGroup, @Param("typeIds") List<String> typeIds, @Param("offset") int offset, @Param("pageSize") Integer pageSize);

    Integer totalCount(@Param("infoSourceMainGroup") InfoSourceMainGroup infoSourceMainGroup, @Param("typeIds") List<String> typeIds);

    List<InfoSourceMainGroupPage> countList(@Param("groupIds") List<String> groupIds);

    InfoSourceMainGroupPage selectGroupById(@Param("groupId") String groupId);

    List<String> selectInfoSourceByGroupIds(@Param("groupIds") List<String> groupIds);

    List<InfoSourceVo> bindListByGroupIds(@Param("groupIds") List<String> groupIds);

    List<InfoSourceMainGroupPage> listByTypeIdList(@Param("groupTypeIdList") List<String> groupTypeIdList, @Param("subjectId") String subjectId, @Param("status") int status, @Param("keywords") String keywords);

    List<InfoSourceVo> pageListByGroupId(@Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("ynBind") Integer ynBind, @Param("groupId") String groupId, @Param("offset") int offset, @Param("pageSize") Integer pageSize);

    Integer totalCountByGroupId(@Param("infoSourceVo") InfoSourceVo infoSourceVo, @Param("ynBind") Integer ynBind, @Param("groupId") String groupId);

    List<InfoSourceMainGroupPage> bindInfoSourceMainGroupList(@Param("subjectId") String subjectId, @Param("types") List<Integer> types);

    List<InfoSourceMain> bindInfoSourceMainList(@Param("subjectId") String subjectId, @Param("types") List<Integer> types);

    List<InfoSourceMainGroupPage> bindInfoSourceMainLabelList(@Param("subjectId") String subjectId, @Param("types") List<Integer> types);
}
