package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件分析版本表
* @TableName event_analysis_version
*/
@Data
@TableName("event_analysis_version")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EventAnalysisVersion implements Serializable {

    /**
    * 版本id
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 事件id
    */
    private String eventId;
    /**
    * 版本名称
    */
    private String versionName;
    /**
    * ppt地址
    */
    private String pptPath;
    /**
    * 创建人
    */
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
    * 更新人
    */
    private String updateBy;
    /**
    * 更新时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
