package com.zzsn.event.llm;

/**
 * 模型调用
 */
public interface LlmService {

    /**
     * glm模型调用
     *
     * @param model   模型类型
     * @param system  提示词
     * @param content 引用内容
     * @return 大模型响应结果
     */
    String model(String model, String system, String content);

    /**
     * 采集词推荐(定制自定义专题)
     *
     * @param modelName 模型名称
     * @param prompt    提示词
     * @param content   输入的内容
     * @author lkg
     * @date 2025/8/16
     */
    String crawlerWord(String modelName, String prompt, String content);
}
