package com.zzsn.event.service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.entity.*;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.util.CronUtil;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.util.user.UserVo;
import com.zzsn.event.vo.AddEventVO;
import com.zzsn.event.vo.RegionVO;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 简化版事件新增逻辑
 *
 * @author lkg
 * @date 2024/7/22
 */
@Service
public class EventSimpleService {

    @Autowired
    private CodeGenerateUtil codeGenerateUtil;
    @Autowired
    private IEventService eventService;
    @Autowired
    private ISubjectTypeMapService subjectTypeMapService;
    @Autowired
    private IProjectSubjectMapService projectSubjectMapService;
    @Autowired
    private IEventTagService eventTagService;
    @Autowired
    private EventRegionMapService eventRegionMapService;
    @Autowired
    private EventExtractService eventExtractService;

    //默认搜索引擎

    /**
     * 新增事件(页面简化版)
     *
     * @param addEventVO 事件信息
     * @author lkg
     * @date 2024/7/19
     */
    @Transactional
    public Event simpleSave(AddEventVO addEventVO) {
        Event event = new Event();
        BeanUtils.copyProperties(addEventVO, event);
        event.setStatus(1);
        Date endTime = event.getEndTime();
        if (endTime == null) {
            endTime = DateUtil.addDate(new Date(), 15);
        }
        event.setEndTime(endTime);
        event.setIncreAnaRule(20);
        event.setTotalAnaRule(50);
        event.setTimeAnaRule(5);
        String subjectCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.SUBJECT_DEFAULT.getValue());
        event.setEventCode(subjectCode);
        //默认发布
        event.setPublishStatus(1);
        event.setPublishDate(DateUtil.dateToString(new Date()));
        //调度周期，默认2小时
        event.setUnit("2");
        event.setSpace(1);
        event.setCron(CronUtil.generateCron("2",1));
        event.setCreateTime(new Date());
        UserVo currentUser = UserUtil.getLoginUser();
        event.setCreateBy(currentUser.getUsername());
        eventService.save(event);
        String eventId = event.getId();
        CompletableFuture.runAsync(()->{
            //删除伪事件
            Integer category = addEventVO.getCategory();
            if (category != null && category == 2) {
                eventExtractService.update(Wrappers.<EventExtract>lambdaUpdate().set(EventExtract::getDeleteStatus, 1)
                        .eq(EventExtract::getId, addEventVO.getFakeEventId()));
            }
            saveMapMain(eventId);
            //事件标签
            eventTagService.save(EventTag.builder().eventId(eventId).build());
            //地域关系绑定
            List<RegionVO> regionList = addEventVO.getRegionList();
            addRegionMap(eventId, regionList);
            //默认绑定搜索引擎、模型
            eventService.saveDefaultMap(eventId);
        });
        return event;
    }

    public void updateMain(AddEventVO addEventVO){
        String eventId = addEventVO.getId();
        Event event = new Event();
        BeanUtils.copyProperties(addEventVO, event);
        eventService.updateById(event);
        CompletableFuture.runAsync(()->{
            //地域关系绑定
            List<RegionVO> regionList = addEventVO.getRegionList();
            addRegionMap(eventId, regionList);
        });
    }

    private void saveMapMain(String eventId) {
        //专题和分类关系
        SubjectTypeMap subjectTypeMap = new SubjectTypeMap();
        subjectTypeMap.setSubjectId(eventId);
        subjectTypeMap.setCreateTime(new Date());
        //分类默认 研究中心
        subjectTypeMap.setTypeId("1802619433932296193");
        subjectTypeMapService.save(subjectTypeMap);
        //专题和项目关系
        ProjectSubjectMap projectSubjectMap = new ProjectSubjectMap();
        //项目默认 研究中心
        projectSubjectMap.setProjectId("1476527644425682945");
        projectSubjectMap.setSubjectId(eventId);
        projectSubjectMapService.save(projectSubjectMap);
    }



    private void addRegionMap(String eventId, List<RegionVO> regionList) {
        if (CollectionUtils.isNotEmpty(regionList)) {
            List<EventRegionMap> dataList = new ArrayList<>();
            for (RegionVO regionVO : regionList) {
                EventRegionMap eventRegionMap = new EventRegionMap();
                eventRegionMap.setEventId(eventId);
                eventRegionMap.setRegionId(regionVO.getId());
                eventRegionMap.setTopRegionId(regionVO.getTopId());
                eventRegionMap.setType(regionVO.getType());
                eventRegionMap.setCreateTime(new Date());
                dataList.add(eventRegionMap);
            }
            eventRegionMapService.saveBatch(dataList);
        }
    }
}
