package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SysDictItem;
import com.zzsn.event.vo.DictTreeVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @Author zhangweijian
 * @since 2018-12-28
 */
@Mapper
public interface SysDictItemMapper extends BaseMapper<SysDictItem> {

    List<SysDictItem> listByDictCode(@Param("dictCode") String dictCode);
    List<SysDictItem> listByDictCodes(@Param("dictCodes") List<String> dictCodes);

    SysDictItem dictItemInfoByName(@Param("dictCode") String dictCode,@Param("itemName") String itemName);

    /**
     * 获取字典值信息
     *
     * @param dictIds 字典id集合
     * @return
     * @author lkg
     * @date 2024/12/30
     */
    List<DictTreeVO> dictItemList(List<String> dictIds);
}
