package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.enums.CodePrefixEnum;
import com.zzsn.event.mapper.KeyWordsMapper;
import com.zzsn.event.service.IKeyWordsService;
import com.zzsn.event.service.ISubjectKeywordsMapService;
import com.zzsn.event.util.CodeGenerateUtil;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsVO;
import com.zzsn.event.vo.SubjectKeywordsMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
@Service
public class KeyWordsServiceImpl extends ServiceImpl<KeyWordsMapper, KeyWords> implements IKeyWordsService {
    @Autowired
    private ISubjectKeywordsMapService subjectKeywordsMapService;
    @Autowired
    private CodeGenerateUtil codeGenerateUtil;

    @Override
    public KeyWords saveKeyword(Event event, String keyword, String exclusionWord) {
        KeyWords keyWords = new KeyWords();
        if (StringUtils.isNotEmpty(keyword) || StringUtils.isNotEmpty(exclusionWord)) {
            //关键词
            String wordsCode = codeGenerateUtil.geneCodeNo(CodePrefixEnum.KEY_WORDS_DEFAULT.getValue());
            keyWords.setWordsCode(wordsCode);
            keyWords.setWordsName(event.getEventName() + "_" + System.currentTimeMillis());
            keyWords.setKeyWord(keyword);
            keyWords.setExclusionWord(exclusionWord);
            keyWords.setStatus("1");
            keyWords.setCreateTime(new Date());
            save(keyWords);
            String keyWordsId = keyWords.getId();
            /*//关键词和分类关系
            KeywordsTypeMap keywordsTypeMap = new KeywordsTypeMap();
            keywordsTypeMap.setKeywordsId(keyWordsId);
            //分类默认 事件专题
            keywordsTypeMap.setTypeId("1802634369064525826");
            keywordsTypeMap.setCreateTime(new Date());
            keywordsTypeMapService.save(keywordsTypeMap);*/
            //专题和关键词关系
            SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
            subjectKeywordsMap.setKeywordsId(keyWordsId);
            subjectKeywordsMap.setSubjectId(event.getId());
            subjectKeywordsMapService.save(subjectKeywordsMap);
        }
        return keyWords;
    }

    @Override
    public KeyWords saveKeyword(String subjectId, KeyWords keyWords) {
        if (keyWords != null){
            save(keyWords);
            String keyWordsId = keyWords.getId();
            //专题和关键词关系
            SubjectKeywordsMap subjectKeywordsMap = new SubjectKeywordsMap();
            subjectKeywordsMap.setKeywordsId(keyWordsId);
            subjectKeywordsMap.setSubjectId(subjectId);
            subjectKeywordsMapService.save(subjectKeywordsMap);
        }
        return keyWords;
    }


    @Override
    public List<KeyWordsPage> bindKeyWordsList(String subjectId) {
        return baseMapper.selectKeyWordsListById(subjectId);
    }

    @Override
    public KeywordsVO keywordInfoByEventId(String eventId) {
        return baseMapper.keywordInfoByEventId(eventId);
    }

}
