package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Constants;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.service.AnalysisService;
import com.zzsn.event.es.EsService;
import com.zzsn.event.service.IEventService;
import com.zzsn.event.service.SubjectAnalysisService;
import com.zzsn.event.util.DateUtil;
import com.zzsn.event.vo.PropagationPathVo;
import com.zzsn.event.vo.SubjectDataVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lkg
 * @description:
 * @date 2022/7/20 11:32
 */
@Service
public class AnalysisServiceImpl implements AnalysisService {

    @Autowired
    private SubjectAnalysisService subjectAnalysisService;
    @Autowired
    private IEventService eventService;
    @Autowired
    private EsService esService;

    /*
     * 优先级：事件脉络 > 伪事件脉络 > 资讯
     * 1.若事件脉络资讯数量少于展示伪事件脉络的阈值(6)，若有伪事件脉络就展示，若无则根据发布时间倒序后，默认取前15条资讯为事件脉络。
     * 2.若事件脉络资讯数量少于展示伪事件脉络的阈值(6)但不为空；
     * 2.1 若有伪事件脉络就展示，若无则展示事件脉络；
     * 2.2 若有伪事件脉络就展示，若无则根据发布时间倒序后，默认取前15条资讯为事件脉络。
     * 3.若事件脉络资讯数量大于/等于展示伪事件脉络的阈值(6)，则直接展示
     *
     * 伪事件脉络/资讯作为事件脉络的情况一般是资讯数量少/刚建立/时间脉络抽取失败的事件专题，才会触发。
     */
    @Override
    public List<SubjectAnalysis> eventContext(String subjectId, int fakeNum) {
        //专题下的事件脉络
        List<SubjectAnalysis> list = getList(subjectId, 2);
        if (list.size() < fakeNum) {
            //专题下的伪事件脉络
            List<SubjectAnalysis> fakeList = getList(subjectId, 3);
            if (CollectionUtils.isEmpty(fakeList)) {
                if (CollectionUtils.isEmpty(list)) {
                    List<SubjectAnalysis> finalList = new ArrayList<>();
                    List<SubjectDataVo> dataList = esService.pageList(subjectId, null, null, Constants.FETCH_FIELDS_STATISTIC, 2,1, 15);
                    dataList.forEach(e -> {
                        String dataId = e.getId();
                        SubjectAnalysis subjectAnalysis = new SubjectAnalysis();
                        BeanUtils.copyProperties(e, subjectAnalysis);
                        subjectAnalysis.setId(null);
                        subjectAnalysis.setDataId(dataId);
                        subjectAnalysis.setPublishDate(DateUtil.stringToDate(e.getPublishDate(), "yyyy-MM-dd HH:mm:ss"));
                        finalList.add(subjectAnalysis);
                    });
                    list = finalList;
                }
            } else {
                list = fakeList;
            }
        }
        return list;
    }


    @Override
    public PropagationPathVo propagationPath(String subjectId) {
        PropagationPathVo top = null;
        Event event = eventService.getById(subjectId);
        String subjectName = event.getEventName();
        //获取专题数据
        String startDate = null;
        String endDate = null;
        if (event.getStartTime() != null) {
            startDate = DateUtil.dateToString(event.getStartTime(), "yyyy-MM-dd HH:mm:ss");
        }
        if (event.getEndTime() != null) {
            endDate = DateUtil.dateToString(event.getEndTime(), "yyyy-MM-dd HH:mm:ss");
        }
        List<SubjectDataVo> specialDataList = esService.getDataBySubjectId(event.getId(), startDate, endDate, Constants.FETCH_FIELDS_STATISTIC);
        if (CollectionUtils.isNotEmpty(specialDataList)) {
            //用于来源去重
            List<String> allOriginList = new ArrayList<>();
            top = new PropagationPathVo();
            top.setName(subjectName);
            top.setTime(DateUtil.dateToString(event.getStartTime()));
            //获取发布时间最早的前10的资讯(来源不重复)
            List<PropagationPathVo> secondList = new ArrayList<>();
            List<SubjectDataVo> earlyList = topN(specialDataList,Constants.FAKE_NUM);
            earlyList.forEach(e->allOriginList.add(Constants.getRealOrigin(e.getOrigin())));
            for (SubjectDataVo subjectDataVo : earlyList) {
                String origin = subjectDataVo.getOrigin();
                String time = subjectDataVo.getPublishDate();
                if (StringUtils.isNotEmpty(origin)) {
                    PropagationPathVo second = new PropagationPathVo();
                    second.setName(Constants.getRealOrigin(origin));
                    second.setTime(time);
                    secondList.add(second);
                    List<String> thirdList = esService.groupByOrigin(subjectDataVo.getTitle(), subjectDataVo.getPublishDate());
                    thirdList.removeAll(allOriginList);
                    List<PropagationPathVo> lastList = new ArrayList<>();
                    if (thirdList.size() > 3) {
                        thirdList = thirdList.subList(0,3);
                    }
                    for (String s : thirdList) {
                        PropagationPathVo third = new PropagationPathVo();
                        third.setName(s);
                        lastList.add(third);
                    }
                    second.setChildren(lastList);
                    allOriginList.addAll(thirdList);
                }
            }
            top.setChildren(secondList);
        }
        return top;
    }
    //获取发布时间最早的前N条资讯(来源不重复)
    private List<SubjectDataVo> topN(List<SubjectDataVo> list,Integer num){
        List<SubjectDataVo> collect = list.stream().filter(e -> StringUtils.isNotEmpty(e.getOrigin())).
                sorted(Comparator.comparing(SubjectDataVo::getPublishDate)).collect(Collectors.toList());
        TreeSet<SubjectDataVo> subjectDataVos = new TreeSet<>(Comparator.comparing(SubjectDataVo::getOrigin));
        for (SubjectDataVo subjectDataVo : collect) {
            subjectDataVos.add(subjectDataVo);
            if (subjectDataVos.size() == num) {
                break;
            }
        }
        return new ArrayList<>(subjectDataVos);
    }

    private List<SubjectAnalysis> getList(String subjectId, Integer category) {
        LambdaQueryWrapper<SubjectAnalysis> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectAnalysis::getSubjectId, subjectId).eq(SubjectAnalysis::getCategory, category).orderByDesc(SubjectAnalysis::getPublishDate);
        return subjectAnalysisService.list(queryWrapper);
    }

}
