package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.Event;
import com.zzsn.event.entity.KeyWords;
import com.zzsn.event.vo.KeyWordsPage;
import com.zzsn.event.vo.KeywordsVO;

import java.util.List;

/**
 * @Description: 关键词管理
 * @Author: jeecg-boot
 * @Date: 2021-11-26
 * @Version: V1.0
 */
public interface IKeyWordsService extends IService<KeyWords> {

    KeyWords saveKeyword(Event event, String keyword, String exclusionWord);

    KeyWords saveKeyword(String subjectId, KeyWords keyWords);
    /**
     * 获取专题绑定的信息源列表
     */
    List<KeyWordsPage> bindKeyWordsList(String subjectId);

    /**
     * 事件绑定关键词信息
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2024/9/12
     */
    KeywordsVO keywordInfoByEventId(String eventId);
}
