package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectInfoSourceMap;
import com.zzsn.event.mapper.SubjectInfoSourceMapMapper;
import com.zzsn.event.service.ISubjectInfoSourceMapService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Description: 专题与信息源关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Service
public class SubjectInfoSourceMapServiceImpl extends ServiceImpl<SubjectInfoSourceMapMapper, SubjectInfoSourceMap> implements ISubjectInfoSourceMapService {

    @Override
    @Transactional
    public void delete(String subjectId){
        baseMapper.deleteBySubjectId(subjectId);
    }

    @Override
    @Transactional
    public void deleteBySubjectIds(List<String> subjectIds){
        baseMapper.deleteBySubjectIds(subjectIds);
    }

    @Override
    public void deleteInfoSourceIds(String subjectId, List<String> infoSourceIds, Integer type){
        baseMapper.deleteInfoSourceIds(subjectId, infoSourceIds, type);
    }

    @Override
    public List<String> selectInfoSourceBySubject(List<String> subjectIds, Integer... type ){
        List<String> list = new ArrayList<>();
        if(subjectIds != null && subjectIds.size() > 0) {
            list = baseMapper.selectInfoSourceBySubjectAndTypes(subjectIds, Arrays.asList(type));
        }
        return list;
    }



    @Override
    public void deleteInfoSourceMapByInfoSourceIds(List<String> infoSourceIds){
        baseMapper.deleteInfoSourceMapByInfoSourceIds(infoSourceIds);
    }

    @Override
    public void updateMain(SubjectInfoSourceMap subjectInfoSourceMap){
        //更新信息源组信息权重
        baseMapper.updateById(subjectInfoSourceMap);
        //更新绑定的信息源权重(根据绑定的信息源组实现)
        baseMapper.infoSourceWeight(subjectInfoSourceMap.getSubjectId(), subjectInfoSourceMap.getSourceId(), subjectInfoSourceMap.getWeight());
    }

    @Override
    public List<String> querySubjectIdsByGroupId(String infoSourceGroupId){
        return baseMapper.selectSubjectIdsByGroupId(infoSourceGroupId);
    }



}
