package com.zzsn.event.entity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Description: 文件操作日志
 * Author: EDY
 * Date: 2023/7/26
 */
@Data
@Accessors(chain = true)
@TableName("clb_file_operation_log")
@ApiModel(value="clb_file_operation_log对象", description="文件操作日志")
public class ClbFileOperationLog {
    /** 唯一标识 */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value ="唯一标识")
    private String id ;
    /** 用户id */
    @ApiModelProperty(value ="用户id")
    private String operationUserId ;
    /** 用户名称 */
    @ApiModelProperty(value ="用户名称")
    private String userName ;
    /** 用户名称 */
    @ApiModelProperty(value ="用户中文名称")
    private String userCnName ;
    /** 专题id */
    @ApiModelProperty(value ="专题id")
    private String subjectId;
    /** 文件名 */
    @ApiModelProperty(value ="文件名")
    private String fileName ;
    /** 文件url */
    @ApiModelProperty(value ="文件url")
    private String fileUrl ;
    /** 操作状态，0处理中，1处理完成 */
    @ApiModelProperty(value ="操作状态，0处理中，1处理完成")
    private Integer operationStatus = 0;
    /** 处理进度 */
    @ApiModelProperty(value ="处理进度")
    private String processing;
    /** 处理成功条数 */
    @ApiModelProperty(value ="处理成功条数")
    private Integer successCount ;
    /** 处理失败条数 */
    @ApiModelProperty(value ="处理失败条数")
    private Integer failCount ;
    /** 整个文件处理失败标识0成功，1异常 */
    @ApiModelProperty(value ="整个文件处理失败标识0成功，1异常")
    private Integer globalFailure = 0;
    /** 整个文件处理失败描述 */
    @ApiModelProperty(value ="整个文件处理失败描述")
    private String globalFailureDesc ;
    /** 操作类型，0导入，1导出 */
    @ApiModelProperty(value ="操作类型，0导入，1导出")
    private Integer operationType = 0;
    /** 创建时间 */
    @ApiModelProperty(value ="创建时间")
    private Date createTime ;
    /** 修改时间 */
    @ApiModelProperty(value ="创建时间")
    private Date updateTime ;
    /** 备注 */
    @ApiModelProperty(value ="备注")
    private String remark ;
    @TableField(exist = false)
    private List<ClbFileOperationLogDetails> clbFileOperationLogDetails = new ArrayList<>();

}
