package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 关键词过滤配置
* @TableName clb_keyword_conf
*/
@Data
@TableName("clb_keyword_conf")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="clb_keyword_conf对象", description="关键词过滤配置")
public class KeywordConf implements Serializable {

    /**
    *
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 分类id
    */
    private String databaseId;
    /**
    * 分类类型
    */
    private String databaseType;
    /**
    * 关键词
    */
    private String keyword;
    /**
    * 0:黑名单 1:白名单
    */
    private Integer type;
    /**
    * 作用范围 0:全库  1:本库
    */
    private Integer rangeType;
    /**
    * 创建人
    */
    private String createBy;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
