package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.mapper.SubjectTypeMapper;
import com.zzsn.event.service.ISubjectTypeService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.util.user.UserUtil;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectTreeVO;
import com.zzsn.event.vo.SubjectTypeTreeVO;
import com.zzsn.event.vo.SubjectTypeVo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 *
 *
 * @author lkg
 * @date 2024/4/28
 */
@Service
public class SubjectTypeServiceImpl extends ServiceImpl<SubjectTypeMapper, SubjectType> implements ISubjectTypeService {

    @Override
    public List<Node> enableList(Integer category) {
        return baseMapper.enableList(category,null);
    }

    @Override
    public List<Node> researchCenterEnableList(String username) {
        return baseMapper.enableList(1, username);
    }

    @Override
    public List<String> belowIdList(String typeId,Integer category) {
        List<Node> nodes = this.enableList(category);
        return TreeUtil.belowList(nodes, typeId, true);
    }

    @Override
    public void add(SubjectType subjectType) {
        if (StringUtils.isEmpty(subjectType.getPid())) {
            subjectType.setPid("0");
        } else {
            //如果当前节点父ID不为空 则设置父节点的hasChildren 为1
            SubjectType parent = baseMapper.selectById(subjectType.getPid());
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                baseMapper.updateById(parent);
            }
        }
        baseMapper.insert(subjectType);
    }

    @Override
    public void edit(SubjectType subjectType) {
        SubjectType entity = this.getById(subjectType.getId());
        String oldPid = entity.getPid();
        String newPid = subjectType.getPid();
        if (!oldPid.equals(newPid)) {
            updateOldParentNode(oldPid);
            if (StringUtils.isEmpty(newPid)) {
                subjectType.setPid("0");
            }
            if (!"0".equals(subjectType.getPid())) {
                baseMapper.updateTreeNodeStatus(subjectType.getPid(), "0");
            }
        }
        baseMapper.updateById(subjectType);
    }

    @Override
    @Transactional
    public void delete(String typeId) {
        SubjectType byId = getById(typeId);
        String pid = byId.getPid();
        baseMapper.deleteById(typeId);
        LambdaQueryWrapper<SubjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectType::getPid,pid);
        Integer count = baseMapper.selectCount(queryWrapper);
        if (count == 0) {
            baseMapper.updateTreeNodeStatus(pid,"0");
        }
    }

    @Override
    public List<SubjectTreeVO> subjectsByFacePublic(Integer facePublic) {
        return baseMapper.subjectsByFacePublic(facePublic);
    }

    @Override
    public List<SubjectTreeVO> subjectAndTypeTree() {
        String username = UserUtil.getLoginUser().getUsername();
        List<SubjectTreeVO> tree = new ArrayList<>();
        List<SubjectTreeVO> subjectTreeVOS = baseMapper.subjectAndTypeTree(username);
        if (CollectionUtils.isNotEmpty(subjectTreeVOS)) {
            tree = TreeUtil.tree(subjectTreeVOS, "0");
        }
        return tree;
    }

    @Override
    public List<SubjectTreeVO> subjectAndCustomerTree(String userId,String customerId) {
        List<SubjectTreeVO> subjectTreeVOS = baseMapper.enableCustomerList(customerId);
        List<SubjectTreeVO> list = baseMapper.subjectAndCustomerTree(userId,customerId);
        subjectTreeVOS.addAll(list);
        List<SubjectTreeVO> tree = TreeUtil.tree(subjectTreeVOS, "0");
        tree.forEach(this::subjectNumCount);
        return tree;
    }

    @Override
    public List<SubjectTreeVO> eventAndTypeTree(String userId, String customerId) {
        List<SubjectTreeVO> tree = new ArrayList<>();
        List<SubjectTreeVO> subjectTreeVOS = baseMapper.eventAndTypeTree(userId,customerId);
        if (CollectionUtils.isNotEmpty(subjectTreeVOS)) {
            tree = TreeUtil.tree(subjectTreeVOS, "0");
        }
        return tree;
    }

    @Override
    public List<String> researchCenterBelowIdList(String typeId, Integer category) {
        String username = UserUtil.getLoginUser().getUsername();
        List<Node> nodes = baseMapper.enableList(category,username);
        return TreeUtil.belowList(nodes, typeId, true);
    }

    @Override
    public List<SubjectTypeTreeVO> typeAndBindCountTreeList(Integer category) {
        List<SubjectTypeTreeVO> resultList = new ArrayList<>();
        LambdaQueryWrapper<SubjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectType::getCategory, category).orderByAsc(SubjectType::getCreateTime);
        List<SubjectType> allList = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(allList)) {
            //绑定有专题/事件的分类
            List<SubjectTypeTreeVO> subjectTypeTreeVOS = baseMapper.typeBindCountTreeList(category);
            if (CollectionUtils.isNotEmpty(subjectTypeTreeVOS)) {
                List<String> collect = subjectTypeTreeVOS.stream().map(SubjectTypeTreeVO::getId).collect(Collectors.toList());
                //补充未绑定专题的分类
                for (SubjectType subjectType : allList) {
                    if (!collect.contains(subjectType.getId())) {
                        SubjectTypeTreeVO subjectTypeTreeVO = new SubjectTypeTreeVO();
                        subjectTypeTreeVO.setId(subjectType.getId());
                        subjectTypeTreeVO.setName(subjectType.getTypeName());
                        subjectTypeTreeVO.setPid(subjectType.getPid());
                        subjectTypeTreeVO.setSubjectCount(0);
                        subjectTypeTreeVO.setCreateTime(subjectType.getCreateTime());
                        subjectTypeTreeVOS.add(subjectTypeTreeVO);
                    }
                }
                //构造树型结构
                resultList = TreeUtil.tree(subjectTypeTreeVOS, "0");
                //递归统计绑定专题的数量
                for (SubjectTypeTreeVO treeVO : resultList) {
                    recursionSum(treeVO);
                }
            } else {
                List<SubjectTypeTreeVO> list = new ArrayList<>();
                allList.forEach(e->{
                    SubjectTypeTreeVO subjectTypeTreeVO = new SubjectTypeTreeVO();
                    subjectTypeTreeVO.setId(e.getId());
                    subjectTypeTreeVO.setName(e.getTypeName());
                    subjectTypeTreeVO.setPid(e.getPid());
                    subjectTypeTreeVO.setSubjectCount(0);
                    subjectTypeTreeVO.setCreateTime(e.getCreateTime());
                    list.add(subjectTypeTreeVO);
                });
                resultList = TreeUtil.tree(list, "0");
            }
            resultList.sort(Comparator.comparing(SubjectTypeTreeVO::getCreateTime));
        }
        return resultList;
    }

    /**
     * 递归获取所有子节点绑定专题数量总和，并赋值给当前节点
     *
     * @param treeVO 当前节点
     * @author lkg
     * @date 2025/1/8
     */
    void recursionSum(SubjectTypeTreeVO treeVO) {
        Integer subjectCount = treeVO.getSubjectCount();
        int sum = getBelowSubjectCount(treeVO);
        treeVO.setSubjectCount(subjectCount + sum);
        if (treeVO.getChildren() != null && !treeVO.getChildren().isEmpty()) {
            for (SubjectTypeTreeVO child : (List<SubjectTypeTreeVO>)treeVO.getChildren()) {
                recursionSum(child);
            }
        }
    }

    /**
     * 递归获取所有子节点绑定专题数量总和
     *
     * @param treeVO 当前节点
     * @author lkg
     * @date 2025/1/8
     */
    private int getBelowSubjectCount(SubjectTypeTreeVO treeVO){
        int sum = 0;
        if (treeVO.getChildren() != null && !treeVO.getChildren().isEmpty()) {
            for (SubjectTypeTreeVO child : (List<SubjectTypeTreeVO>)treeVO.getChildren()) {
                sum += child.getSubjectCount();
                sum += getBelowSubjectCount(child);
            }
        }
        return sum;
    }
    private void subjectNumCount(SubjectTreeVO subjectTreeVO) {
        Boolean ynSubject = subjectTreeVO.getYnSubject();
        if (!ynSubject) {
            int num = 0;
            List<? extends Node> children = subjectTreeVO.getChildren();
            if (CollectionUtils.isNotEmpty(children)) {
                for (Node node : children) {
                    SubjectTreeVO subjectTreeNode = (SubjectTreeVO)node;
                    subjectNumCount(subjectTreeNode);
                    num = num + 1;
                }
                subjectTreeVO.setSubjectCount(num);
            }
        }
    }
    @Override
    public List<SubjectTypeVo> subjectListByType(String parentId) {
        if (!parentId.equals("0")) {
            SubjectType subjectTypeVo1 = this.getById(parentId);
            if (StringUtils.isEmpty(subjectTypeVo1.getHasChild()) || "0".equals(subjectTypeVo1.getHasChild())) {
                List<SubjectTypeVo> list = new ArrayList<>();
                List<SubjectPage> subjectList = baseMapper.subjectListByType(subjectTypeVo1.getId());
                if (subjectList != null && !subjectList.isEmpty()) {
                    for (SubjectPage subjectPage : subjectList) {
                        SubjectTypeVo subjectTypeVo2 = new SubjectTypeVo();
                        subjectTypeVo2.setId(subjectPage.getId());
                        subjectTypeVo2.setHasChild(null);
                        subjectTypeVo2.setTypeName(subjectPage.getSubjectName());
                        subjectTypeVo2.setPid(subjectTypeVo1.getId());
                        subjectTypeVo2.setIsSubject(true);
                        list.add(subjectTypeVo2);
                    }
                }
                return list;
            }
        }
        SubjectTypeVo subjectTypeVo = new SubjectTypeVo();
        subjectTypeVo.setId(parentId);
        subjectTypeVo.setTypeName(parentId.equals("1") ? "所有" : null);
        subjectTypeVo.setHasChild("1");
        LambdaQueryWrapper<SubjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectType::getCategory,1);
        List<SubjectType> list = baseMapper.selectList(queryWrapper);
        List<SubjectTypeVo> typeVoList = new ArrayList<>();
        for (SubjectType type : list) {
            SubjectTypeVo typeVo = new SubjectTypeVo();
            BeanUtils.copyProperties(type,typeVo);
            typeVoList.add(typeVo);
        }
        Map<String, List<SubjectTypeVo>> pidMap = typeVoList.stream().collect(Collectors.groupingBy(SubjectTypeVo::getPid));
        //筛选一级分类
        List<SubjectTypeVo> firstGroup = typeVoList.stream().filter(item -> item.getPid().equals(parentId)).collect(Collectors.toList());

        for (SubjectTypeVo typeVo : firstGroup) {
            if (StringUtils.isEmpty(typeVo.getHasChild()) || "0".equals(typeVo.getHasChild())) {
                List<String> oneInList = new ArrayList<>();
                oneInList.add(typeVo.getId());
                //tips 当数据量大 最好不用列表
                Integer count = baseMapper.typeBindSubjectCount(oneInList);
                typeVo.setSubjectCount(count);
            } else {
                //获取每个下面最后一级分类列表
                List<SubjectTypeVo> singleList = new ArrayList<>(1);
                singleList.add(typeVo);
                List<SubjectTypeVo> finalGradeList = new ArrayList<>();
                getFinalIdListInMap(singleList, pidMap, finalGradeList);
                List<String> finalIdList = finalGradeList.stream().map(SubjectTypeVo::getId).collect(Collectors.toList());
                if (!finalIdList.isEmpty()) {
                    Integer count = baseMapper.typeBindSubjectCount(finalIdList);
                    typeVo.setSubjectCount(count);
                } else {
                    typeVo.setSubjectCount(0);
                }
            }
        }
        return firstGroup;
    }

    @Override
    public List<SubjectTypeVo> eventListByType(String parentId) {
        if (!parentId.equals("0")) {
            SubjectType subjectTypeVo1 = this.getById(parentId);
            if (StringUtils.isEmpty(subjectTypeVo1.getHasChild()) || "0".equals(subjectTypeVo1.getHasChild())) {
                List<SubjectTypeVo> list = new ArrayList<>();
                List<SubjectPage> subjectList = baseMapper.eventListByType(subjectTypeVo1.getId());
                if (subjectList != null && !subjectList.isEmpty()) {
                    for (SubjectPage subjectPage : subjectList) {
                        SubjectTypeVo subjectTypeVo2 = new SubjectTypeVo();
                        subjectTypeVo2.setId(subjectPage.getId());
                        subjectTypeVo2.setHasChild(null);
                        subjectTypeVo2.setTypeName(subjectPage.getSubjectName());
                        subjectTypeVo2.setPid(subjectTypeVo1.getId());
                        subjectTypeVo2.setIsSubject(true);
                        list.add(subjectTypeVo2);
                    }
                }
                return list;
            }
        }
        SubjectTypeVo subjectTypeVo = new SubjectTypeVo();
        subjectTypeVo.setId(parentId);
        subjectTypeVo.setTypeName(parentId.equals("1") ? "所有" : null);
        subjectTypeVo.setHasChild("1");
        LambdaQueryWrapper<SubjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectType::getCategory,1);
        List<SubjectType> list = baseMapper.selectList(queryWrapper);
        List<SubjectTypeVo> typeVoList = new ArrayList<>();
        for (SubjectType type : list) {
            SubjectTypeVo typeVo = new SubjectTypeVo();
            BeanUtils.copyProperties(type,typeVo);
            typeVoList.add(typeVo);
        }
        Map<String, List<SubjectTypeVo>> pidMap = typeVoList.stream().collect(Collectors.groupingBy(SubjectTypeVo::getPid));
        //筛选一级分类
        List<SubjectTypeVo> firstGroup = typeVoList.stream().filter(item -> item.getPid().equals(parentId)).collect(Collectors.toList());

        for (SubjectTypeVo typeVo : firstGroup) {
            if (StringUtils.isEmpty(typeVo.getHasChild()) || "0".equals(typeVo.getHasChild())) {
                List<String> oneInList = new ArrayList<>();
                oneInList.add(typeVo.getId());
                //tips 当数据量大 最好不用列表
                Integer count = baseMapper.typeBindEventCount(oneInList);
                typeVo.setSubjectCount(count);
            } else {
                //获取每个下面最后一级分类列表
                List<SubjectTypeVo> singleList = new ArrayList<>(1);
                singleList.add(typeVo);
                List<SubjectTypeVo> finalGradeList = new ArrayList<>();
                getFinalIdListInMap(singleList, pidMap, finalGradeList);
                List<String> finalIdList = finalGradeList.stream().map(SubjectTypeVo::getId).collect(Collectors.toList());
                if (!finalIdList.isEmpty()) {
                    Integer count = baseMapper.typeBindEventCount(finalIdList);
                    typeVo.setSubjectCount(count);
                } else {
                    typeVo.setSubjectCount(0);
                }
            }
        }
        return firstGroup;
    }

    private void getFinalIdListInMap(List<SubjectTypeVo> subjectTypeVoList, Map<String, List<SubjectTypeVo>> pidMap, List<SubjectTypeVo> finalAllList) {
        List<SubjectTypeVo> nextGradeNotFinalList = new ArrayList<>();
        for (SubjectTypeVo subjectTypeVo : subjectTypeVoList) {
            List<SubjectTypeVo> tempList = pidMap.get(subjectTypeVo.getId());
            if (tempList != null) {
                List<SubjectTypeVo> finalList = tempList.stream()
                        .filter(item -> null == item.getHasChild() && StringUtils.isEmpty(item.getHasChild()) || "0".equals(item.getHasChild()))
                        .collect(Collectors.toList());
                finalAllList.addAll(finalList);
                tempList.removeAll(finalList);
                nextGradeNotFinalList.addAll(tempList);
            }

        }
        if (nextGradeNotFinalList.isEmpty()) {
            return;
        }
        getFinalIdListInMap(nextGradeNotFinalList, pidMap, finalAllList);
    }

    private void updateOldParentNode(String pid) {
        if (!"0".equals(pid)) {
            Integer count = baseMapper.selectCount(new QueryWrapper<SubjectType>().eq("pid", pid));
            if (count == null || count <= 1) {
                baseMapper.updateTreeNodeStatus(pid, "0");
            }
        }
    }
}
