package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.vo.SubjectPage;
import com.zzsn.event.vo.SubjectTreeVO;
import com.zzsn.event.vo.SubjectTypeTreeVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @Description: 专题类别
 * @Author: jeecg-boot
 * @Date: 2021-12-01
 * @Version: V1.0
 */
@Mapper
public interface SubjectTypeMapper extends BaseMapper<SubjectType> {

    /**
     * 可用的专题分类列表
     *
     * @param category 类别(1-专题;2-事件)
     * @param createBy 创建人
     * @author lkg
     * @date 2024/4/29
     */
    List<Node> enableList(@Param("category") Integer category,@Param("username") String createBy);

    /**
     * 可用的专题和客户列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> subjectAndCustomerTree(@Param("userId") String userId, @Param("customerId") String customerId);

    /**
     * 可用客户信息列表
     *
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/30
     */
    List<SubjectTreeVO> enableCustomerList(@Param("customerId") String customerId);

    /**
     * 更新分类是否有子节点状态
     *
     * @param id       分类id
     * @param hasChild 是否有子节点
     * @author lkg
     * @date 2024/4/29
     */
    void updateTreeNodeStatus(@Param("id") String id, @Param("hasChild") String hasChild);

    /**
     * 按分类分组，获取绑定专题/事件数量
     *
     * @param category 类别(1-专题;2-事件)
     * @author lkg
     * @date 2025/1/8
     */
    List<SubjectTypeTreeVO> typeBindCountTreeList(@Param("category") Integer category);

    /**
     * 根据是否公开获取专题列表
     *
     * @param facePublic 是否公开(1-是;0-否)
     * @author lkg
     * @date 2025/1/7
     */
    List<SubjectTreeVO> subjectsByFacePublic(@Param("facePublic") Integer facePublic);

    /**
     * 可用的事件和分类列表
     *
     * @author lkg
     * @date 2024/4/29
     */
    List<SubjectTreeVO> subjectAndTypeTree(@Param("username") String createBy);

    /**
     * 获取分类下的专题列表
     *
     * @param subjectTypeId 专题/事件分类id
     * @author lkg
     * @date 2024/12/20
     */
    List<SubjectPage> subjectListByType(@Param("subjectTypeId") String subjectTypeId);

    /**
     * 获取分类下的事件数量
     *
     * @param typeIds
     * @author lkg
     * @date 2024/12/20
     */
    Integer typeBindSubjectCount(@Param("typeIds") List<String> typeIds);

    /**
     * 获取分类下的专题列表
     *
     * @param subjectTypeId 专题/事件分类id
     * @author lkg
     * @date 2024/12/20
     */
    List<SubjectPage> eventListByType(@Param("subjectTypeId") String subjectTypeId);

    /**
     * 获取分类下的事件数量
     *
     * @param typeIds
     * @author lkg
     * @date 2024/12/20
     */
    Integer typeBindEventCount(@Param("typeIds") List<String> typeIds);

    /**
     * 可用的事件和事件分类列表
     *
     * @param userId     用户id
     * @param customerId 客户id
     * @author lkg
     * @date 2024/4/29
     */
    List<SubjectTreeVO> eventAndTypeTree(@Param("userId") String userId, @Param("customerId") String customerId);
}
