package com.zzsn.event.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.entity.EventContext;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.vo.EventContextModifyVO;

import java.util.List;
import java.util.Map;

/**
 * @author lenovo
 * @description 针对表【event_context(事件脉络表)】的数据库操作Service
 * @createDate 2025-07-14 18:05:06
 */
public interface EventContextService extends IService<EventContext> {


    List<Map<String,Object>> eventContext(String eventId);

    /**
     * 事件脉络维护(新增/编辑)
     *
     * @param eventContextModifyVO 事件脉络维护参数
     * @author lkg
     * @date 2025/7/15
     */
    void eventContextModify(EventContextModifyVO eventContextModifyVO);

    /**
     * 事件脉络关键节点列表
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/15
     */
    List<EventContext> keNodeList(String eventId);

    /**
     * 关键节点下的资讯列表
     *
     * @param eventId   事件id
     * @param keyNodeId 关键节点id
     * @param pageNo    页码
     * @param pageSize  每页返回数量
     * @author lkg
     * @date 2025/7/15
     */
    Page<EventContext> contextArticleList(String eventId, String keyNodeId, Integer pageNo, Integer pageSize);

    /**
     * 获取最大排序序号
     *
     * @param eventId 事件id
     * @author lkg
     * @date 2025/7/15
     */
    Integer getMaxSortNumber(String eventId);
}
