package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectStatisticInfo;
import com.zzsn.event.mapper.SubjectStatisticInfoMapper;
import com.zzsn.event.service.SubjectStatisticInfoService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * 准提统计信息 业务实现层
 *
 * @author lkg
 * @date 2025/3/25
 */
@Service
public class SubjectStatisticInfoServiceImpl extends ServiceImpl<SubjectStatisticInfoMapper, SubjectStatisticInfo> implements SubjectStatisticInfoService {
    @Override
    @Transactional
    public void batchModify(List<SubjectStatisticInfo> list) {
        for (SubjectStatisticInfo subjectStatisticInfo : list) {
            String subjectId = subjectStatisticInfo.getSubjectId();
            LambdaQueryWrapper<SubjectStatisticInfo> query = Wrappers.lambdaQuery();
            query.eq(SubjectStatisticInfo::getSubjectId, subjectId);
            SubjectStatisticInfo one = this.getOne(query);
            if (one == null) {
                subjectStatisticInfo.setCreateTime(new Date());
                this.save(subjectStatisticInfo);
            } else {
                subjectStatisticInfo.setId(one.getId());
                subjectStatisticInfo.setUpdateTime(new Date());
                this.updateById(subjectStatisticInfo);
            }
        }
    }
}
