package com.zzsn.event.enums;

import com.zzsn.event.vo.log.DataLifecycleLog;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 操作方式枚举，每个操作类型{@link EnumOperateType}对应一组操作方式，每个操作方式属于固定的某个操作类型
 * 所有的操作方式又是同级别的，在{@link DataLifecycleLog}中的operateWay字段中使用
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@Getter
@AllArgsConstructor
public enum EnumOperateWay {
    UNKNOWN("未知", null),


    WORD_PRE("关键词", EnumOperateType.PREPARE_HANDLER),
    LANGUAGE_PRE("语种", EnumOperateType.PREPARE_HANDLER),
    SUMMARY_PRE("摘要", EnumOperateType.PREPARE_HANDLER),
    SOURCE_TYPE_PRE("信息源分类", EnumOperateType.PREPARE_HANDLER),
    TO_BASEDATA("入采集库", EnumOperateType.PREPARE_HANDLER),


    KEYWORD("关键词过滤", EnumOperateType.TO_SUBJECT),
    TO_SUBJECT_MODELED("入库模型处理", EnumOperateType.TO_SUBJECT),
    TO_SUBJECT_MODIFIED("入库修改", EnumOperateType.TO_SUBJECT),
    TO_SUBJECT_MANUAL_ADD("人工添加", EnumOperateType.TO_SUBJECT),


    DEEP_HANDLER_MODELED("深度模型处理", EnumOperateType.DEEP_HANDLER),
    DEEP_SUBJECT_MODIFIED("深度处理入库修改", EnumOperateType.DEEP_HANDLER),

    MANUAL_CHECK("人工审核", EnumOperateType.DATA_CHECK),
    DEFAULT_PASS("免审核", EnumOperateType.DATA_CHECK),

    EDITED("编辑",null),
    EDIT_LABEL("修改标签",null),
    COLLECTED("收藏",null),
    COLLECT_CANCELED("取消收藏",null),
    TOP("置顶",null),
    TOP_CANCELED("取消置顶",null)
    ;

    private final String value;

    private final EnumOperateType parent;
}
