package com.zzsn.event.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.event.vo.InfoSourceCondition;
import com.zzsn.event.vo.InfoSourceVo;
import com.zzsn.event.entity.InfoSource;
import com.zzsn.event.vo.SubjectBindDirectSourceVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date: 2022-01-18
 * @Version: V1.0
 */
@Mapper
public interface InfoSourceMapper extends BaseMapper<InfoSource> {

    /**
     * 信息源分页列表
     *
     * @param infoSourceCondition 筛选条件
     * @author lkg
     * @date 2024/12/26
     */
    Page<InfoSource> pageList(@Param("infoSourceCondition") InfoSourceCondition infoSourceCondition, Page<InfoSource> page);

    /**
     * 信息源信息列表
     *
     * @param sourceIdList 信息源id集合
     * @author lkg
     * @date 2024/5/7
     */
    List<InfoSourceVo> queryInfoSource(@Param("sourceIdList") List<String> sourceIdList, @Param("subjectIds") List<String> subjectIds);

    /**
     * 专题绑定的信息源集合
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @param offset              偏移量
     * @param pageSize            返回条数
     * @author lkg
     * @date 2024/4/24
     */
    List<String> bindSourceIdList(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectIds") List<String> subjectIds, @Param("offset") Integer offset, @Param("pageSize") Integer pageSize);

    /**
     * 专题绑定的信息源总数量
     *
     * @param infoSourceCondition 筛选条件
     * @param subjectIds          专题id集合
     * @author lkg
     * @date 2024/4/24
     */
    Long bindSourceIdCount(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectIds") List<String> subjectIds);

    /**
     * @param subjectIds 专题id集合
     * @param sourceIds
     * @author lkg
     * @date 2025/2/6
     */
    List<InfoSourceVo> bindGroupSourceIdList(@Param("subjectIds") List<String> subjectIds, @Param("sourceIds") List<String> sourceIds);

    /**
     * 专题直接屏蔽的信息源列表(不包括专题屏蔽的信息源组下的信息源)
     *
     * @param infoSourceCondition 筛选条件
     * @param page                分页参数
     * @author lkg
     * @date 2024/4/30
     */
    Page<InfoSourceVo> unBindSourcePageList(@Param("infoSourceVo") InfoSourceCondition infoSourceCondition, Page<InfoSourceVo> page);


    /**
     * 专题绑定的定向信息源分页列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param subjectId 专题id
     * @author lkg
     * @date 2025/1/6
     */
    Page<SubjectBindDirectSourceVO> subjectBindDirectInfoSourceList(@Param("subjectId") String subjectId, Page<Map<String, Object>> page);


    /**
     * 信息源分页列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param searchWord 搜索词
     * @param page       分页参数
     * @author lkg
     * @date 2025/1/4
     */
    Page<SubjectBindDirectSourceVO> infoSourcePageList(@Param("searchWord") String searchWord, Page<String> page);

    /**
     * 信息源下专题绑定的栏目列表(专题绑定定向信息源时使用-研究中心)
     *
     * @param subjectId    专题id
     * @param webSiteNames 信息源名称
     * @author lkg
     * @date 2025/1/4
     */
    List<InfoSource> subjectBindSourceColumnList(@Param("subjectId") String subjectId, @Param("webSiteNames") List<String> webSiteNames);


    IPage<InfoSourceVo> bindSourceIdPageList(Page<InfoSourceVo> page, @Param("infoSourceVo") InfoSourceCondition infoSourceCondition, @Param("subjectIds") List<String> subjectIds);

    List<String> listIdByGroupIds(@Param("groupIds") List<String> groupIds);
}
