package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.ClbFileOperationLogDetails;
import com.zzsn.event.mapper.ClbFileOperationLogDetailsMapper;
import com.zzsn.event.service.IClbFileOperationLogDetailsService;
import org.springframework.stereotype.Service;

import java.util.Date;


@Service
public class ClbFileOperationLogDetailsServiceImpl extends ServiceImpl<ClbFileOperationLogDetailsMapper, ClbFileOperationLogDetails> implements IClbFileOperationLogDetailsService {

    @Override
    public ClbFileOperationLogDetails buildFailDetails(String title, String origin, String url) {
        return new ClbFileOperationLogDetails()
                .setOrigin(origin)
                .setTitle(title)
                .setSourceAddress(url)
                .setOperationStatus(0)
                .setCreateTime(new Date());
    }

    @Override
    public ClbFileOperationLogDetails buildFailDetails(String title, String origin, String url, String desc) {
        return new ClbFileOperationLogDetails()
                .setOrigin(origin)
                .setTitle(title)
                .setSourceAddress(url)
                .setCauseBy(desc)
                .setOperationStatus(1)
                .setCreateTime(new Date());
    }

}
