package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;

/**
 * @Description: 附件表
 * @Author: jeecg-boot
 * @Date:   2022-11-22
 * @Version: V1.0
 */
@Data
@TableName("clb_sys_attachment")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class ClbSysAttachment implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.AUTO)
    private Long id;
	/**文件名称*/
    private String name;
	/**和字典表关联，不通类型记录的附件，用来关联不通的表*/
    private String typeId;
	/**关联记录的id*/
    private String itemId;
	/**fastDFS文件服务器上的分组*/
    private String groupName;
	/**fastDFS服务器上文件的路径*/
    private String path;
	/**文件全路径： group字段和path字段组成*/
    private String fullPath;
	/**文件扩展名*/
    private String category;
	/**文件大小*/
    private String fileSize;
	/**排序编号*/
    private Integer orderBy;
	/**是否生效， 1： 有效， 0 ： 已经删除*/
    private Integer status;
	/**创建人*/
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date createTime;
	/**更新人*/
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private java.util.Date updateTime;
	/**所属部门*/
    private String sysOrgCode;
    /**年份（主要用于企业报告）*/
    private Integer year;
    /**PDF文件总页数*/
    private Integer pageSize;
    /**来源*/
    private String source;
    /**桶名称*/
    private String bucketName;
    /**obs路径*/
    private String objectKey;
}
