package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 信息源表
 * @Author: jeecg-boot
 * @Date:   2021-10-15
 * @Version: V1.0
 */
@ApiModel(value="info_source对象", description="信息源表")
@Data
@TableName("info_source")
public class InfoSource implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private String id;
	/**信息源编码*/
    @ApiModelProperty(value = "信息源编码")
    private String infoSourceCode;
	/**信息源名称*/
    @ApiModelProperty(value = "信息源名称")
    private String webSiteName;
	/**栏目名称*/
    @ApiModelProperty(value = "栏目名称")
    private String siteName;
	/**栏目地址*/
    @ApiModelProperty(value = "栏目地址")
    private String siteUri;
	/**网站重要级别*/
    @ApiModelProperty(value = "网站重要级别")
    private String siteLevel;
	/**国家*/
    @ApiModelProperty(value = "国家")
    private String country;
	/**地区*/
    @ApiModelProperty(value = "地区")
    private String area;
	/**语种*/
    @ApiModelProperty(value = "语种")
    private String language;
	/**创建人*/
    @ApiModelProperty(value = "创建人")
    private String createBy;
	/**创建日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;
	/**更新人*/
    @ApiModelProperty(value = "更新人")
    private String updateBy;
	/**更新日期*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    /**原创来源（中文逗号隔开）*/
    private String originalSource;
    /**爬虫类别*/
    private String crawlType;
    /**爬虫类别*/
    private String status;
}
