package com.zzsn.event.controller.thirdApi;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.Subject;
import com.zzsn.event.service.SubjectSimpleService;
import com.zzsn.event.service.impl.CaiJiCenterHttpService;
import com.zzsn.event.service.impl.ConfigurationMessageService;
import com.zzsn.event.xxljob.service.IXxlJobInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.concurrent.CompletableFuture;

/**
 * 研究中心-政策分析-创建专题
 *
 * @author lkg
 * @date 2025/10/11
 */
@Slf4j
@RestController
@RequestMapping("/third/api")
public class SubjectApi {

    @Autowired
    private SubjectSimpleService subjectSimpleService;
    @Autowired
    private IXxlJobInfoService xxlJobInfoService;
    @Autowired
    private ConfigurationMessageService configurationMessageService;
    @Resource
    private KafkaTemplate<String, String> kafkaTemplate;
    @Autowired
    private CaiJiCenterHttpService caiJiCenterHttpService;
    @Value("${kafka.topic.subject.run:}")
    private String SUBJECT_MODEL_KAFKA_CHANNEL;

    /**
     * 创建专题
     *
     * @param subjectSimpleVO 参数
     * @author lkg
     * @date 2025/1/9
     */
    @PostMapping("/createSubject")
    public Result<?> createSubject(@RequestBody ThirdAddSubjectVO subjectSimpleVO) {
        Subject subject = subjectSimpleService.createPolicySubject(subjectSimpleVO);
        CompletableFuture.runAsync(() -> {
            //插入xxlJob
            xxlJobInfoService.subjectInsert(subject);
        });
        //远程调用，执行采集入库流程
        kafkaTemplate.send(SUBJECT_MODEL_KAFKA_CHANNEL, subject.getSubjectCode());
        configurationMessageService.bindInfoSourceSend(subject.getId());
        configurationMessageService.bindKeyWordsSend(subject.getId(),null);
        configurationMessageService.subjectEnterpriseSourceSync(subject.getId());
        configurationMessageService.subjectPolicySourceSync(subject.getId());
        try {
            String res = caiJiCenterHttpService.subjectStatusEdit(subject.getStatus(), subject.getId());
            cn.hutool.json.JSONObject entries = JSONUtil.parseObj(res);
            //获取code状态码
            Integer code = entries.getInt("code");
            if (ObjectUtil.isEmpty(code) || code != 200) {
                log.error("专题状态同步采集失败{}", res);
            }
        } catch (Exception e) {
            log.error("专题状态同步采集失败{}", e.getMessage(), e);
        }
        return Result.OK(subject.getId());
    }
}
