package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Description: 数据库关键词过滤配置
 * @Author: jeecg-boot
 * @Date: 2023-08-12
 * @Version: V1.0
 */
@Data
@TableName("subject_keywords_group_relation")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SubjectKeywordsGroupRelation {

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    private String subjectId;
    /**
     * 关键词组ids
     */
    private String keywordsGroupIds;
    /**
     * 绑定类型1：采集词词组关系，2：过滤词词组关系，3排除词组词组关系
     */
    private String relationType;
    /**
     * 表达式
     */
    private String expressionStr;
    private String paramsStr;
    /**
     * 创建人
     */
    private String createBy;

    /**
     * 创建日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 更新人
     */
    private String updateBy;

    /**
     * 更新日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


}
