package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
* 事件分析-网络搜索资讯表
* @TableName event_web_search_article
*/
@Data
@TableName("event_web_search_article")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class EventWebSearchArticle implements Serializable {

    /**
    * 主键id
    */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;
    /**
    * 事件分析版本id
    */
    private String versionId;
    /**
    * 角标序号
    */
    private String refer;
    /**
    * 标题
    */
    private String title;
    /**
    * 内容摘要
    */
    private String content;
    /**
    * 网站名称
    */
    private String origin;
    /**
    * 发布时间
    */
    private String publishDate;
    /**
    * 原文链接
    */
    private String sourceAddress;
    /**
    * 网站图标
    */
    private String icon;
    /**
    * 创建时间
    */
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
