package com.zzsn.event.vo.log;

import com.zzsn.event.enums.EnumExceptionType;
import com.zzsn.event.enums.EnumHandlerStatus;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.FieldNameConstants;

/**
 * 持有类为数据生命周期日志{@link DataLifecycleLog}
 * 此类记录各阶段处理成功与否，处理后的数据状态，以及处理结果信息
 *
 * @author 张宗涵
 * @date 2024/4/25
 */
@Getter
@Setter
@FieldNameConstants
public class HandlerBody {
    /**
     * 本次处理是否成功
     */
    private Boolean success;

    /**
     * 处理状态
     */
    private EnumHandlerStatus handlerStatus;

    /**
     * 处理消息，success为false时必填
     */
    private String exceptionMsg;

    /**
     * 异常类型
     */
    private EnumExceptionType exceptionType;

    /**
     * 本次处理结果，json串
     */
    private String handlerResult;
}
