package com.zzsn.event.controller.infosource;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.zzsn.event.constant.Result;
import com.zzsn.event.entity.InfoSourceMain;
import com.zzsn.event.entity.InfoSourceMainGroup;
import com.zzsn.event.entity.InfoSourceMainGroupMap;
import com.zzsn.event.service.IInfoSourceMainGroupMapService;
import com.zzsn.event.service.InfoSourceMainGroupService;
import com.zzsn.event.util.ExcelExportUtil;
import com.zzsn.event.util.ObsUtil;
import com.zzsn.event.vo.InfoSourceGroupPage;
import com.zzsn.event.vo.InfoSourceMainGroupPage;
import com.zzsn.event.vo.InfoSourceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Api(tags = "信息源组")
@RestController
@RequestMapping("/groupMain")
public class InfoSourceMainGroupController {

    @Autowired
    InfoSourceMainGroupService infoSourceMainGroupService;
    @Autowired
    IInfoSourceMainGroupMapService infoSourceMainGroupMapService;
    @Autowired
    private ObsUtil obsUtil;




    /**
     * 分页列表查询
     *
     * @param infoSourceMainGroup
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "信息源组表-分页列表查询", notes = "信息源组表-分页列表查询")
    @GetMapping(value = "/listByTypeId")
    public Result<?> queryPageListByTypeId(InfoSourceMainGroup infoSourceMainGroup,
                                           @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                           @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                           @RequestParam(name = "groupTypeId", defaultValue = "") String groupTypeId) {

        IPage<InfoSourceMainGroupPage> pageList = infoSourceMainGroupService.pageByTypeId(infoSourceMainGroup, pageNo, pageSize, groupTypeId);
        return Result.OK(pageList);
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "信息源组表-通过id查询", notes = "信息源组表-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<?> queryById(@RequestParam(name = "id", required = true) String id) {
        InfoSourceMainGroupPage infoSourceGroup = infoSourceMainGroupService.getGroupById(id);
        if (StrUtil.isNotBlank(infoSourceGroup.getGroupTypeId())) {
            infoSourceGroup.setGroupTypeIds(Arrays.asList(infoSourceGroup.getGroupTypeId().split(",")));
        }
        if (infoSourceGroup == null) {
            return Result.FAIL("未找到对应数据");
        }
        return Result.OK(infoSourceGroup);
    }


    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "信息源组表-通过id删除", notes = "信息源组表-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id", required = true) String id) {
        infoSourceMainGroupService.deleteMain(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "信息源组表-批量删除", notes = "信息源组表-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<?> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.infoSourceMainGroupService.deleteMainByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }


    /**
     * 导出绑定的信息源列表
     *
     * @param groupIds 信息源组id，多个逗号分割
     * @author lkg
     * @date 2025/1/21
     */
    @GetMapping("/exportBindList")
    public void exportBindList(@RequestParam String groupIds, HttpServletResponse response) throws Exception{
        List<InfoSourceVo> infoSourceVos = infoSourceMainGroupService.bindListByGroupIds(Arrays.asList(groupIds.split(",")));
        String[] headers = new String[]{"信息源id", "信息源编码", "信息源名称", "信息源地址"};
        XSSFWorkbook workbook = new XSSFWorkbook();
        Map<String, List<InfoSourceVo>> collect = infoSourceVos.stream().collect(Collectors.groupingBy(InfoSourceVo::getGroupName));
        int sheetNum = 0;
        for (Map.Entry<String, List<InfoSourceVo>> entry : collect.entrySet()) {
            String groupName = entry.getKey();
            List<InfoSourceVo> value = entry.getValue();
            List<List<String>> dataList = value.stream().map(InfoSourceVo::toExcelList).collect(Collectors.toList());
            ExcelExportUtil.exportExcelData(workbook, sheetNum, Arrays.asList(headers), dataList, groupName);
            sheetNum++;
        }
        // 将Workbook写入字节流
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        workbook.write(outStream);
        // 将字节流转换为InputStream
        byte[] bytes = outStream.toByteArray();
        String filename = URLEncoder.encode("绑定的信息源列表.xls", "UTF-8").replace("+", " ");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", "attachment;filename=" + filename);
        response.setContentLength(bytes.length);
        OutputStream out = response.getOutputStream();
        out.write(bytes);
        out.flush();
        out.close();
    }

    /**
     * 编辑
     *
     * @param infoSourceMainGroupPage
     * @return
     */
    @ApiOperation(value = "信息源组表-编辑", notes = "信息源组表-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody InfoSourceMainGroupPage infoSourceMainGroupPage) {
        InfoSourceMainGroup infoSourceGroup = new InfoSourceMainGroup();
        BeanUtils.copyProperties(infoSourceMainGroupPage, infoSourceGroup);
        infoSourceMainGroupService.updateMain(infoSourceGroup, infoSourceMainGroupPage.getGroupTypeIds());
        return Result.OK("编辑成功!");
    }

    /**
     * 添加
     *
     * @param infoSourceMainGroupPage
     * @return
     */
    @ApiOperation(value = "信息源组表-添加", notes = "信息源组表-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody InfoSourceMainGroupPage infoSourceMainGroupPage) {
        InfoSourceMainGroup infoSourceGroup = new InfoSourceMainGroup();
        BeanUtils.copyProperties(infoSourceMainGroupPage, infoSourceGroup);
        infoSourceMainGroupService.saveMain(infoSourceGroup, infoSourceMainGroupPage.getGroupTypeIds());
        return Result.OK("添加成功！");
    }


    /**
     * 查询信息源组的绑定列别
     */
    @ApiOperation(value = "信息源信息源组关联表-绑定", notes = "信息源信息源组关联表-绑定")
    @GetMapping(value = "/bindList")
    public Result<?> bindList(InfoSourceVo infoSourceVo,
                              @RequestParam(name = "ynBind", required = true) Integer ynBind,
                              @RequestParam(name = "groupId", required = true) String groupId,
                              @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        IPage<InfoSourceVo> pageList = infoSourceMainGroupService.pageListByGroupId(infoSourceVo, ynBind, groupId, pageNo, pageSize);
        return Result.OK(pageList);
    }
    /**
     * 绑定信息源
     */
    @ApiOperation(value = "信息源信息源组关联表-绑定", notes = "信息源信息源组关联表-绑定")
    @PostMapping(value = "/bind")
    public Result<?> bind(@RequestBody InfoSourceGroupPage infoSourceGroupPage) {
        String message = infoSourceMainGroupService.bind(infoSourceGroupPage.getId(), infoSourceGroupPage.getInfoSourceIds());
        return Result.OK(message);
    }



    /**
     * 解绑信息源
     */
    @ApiOperation(value = "信息源信息源组关联表-解绑", notes = "信息源信息源组关联表-解绑")
    @PostMapping(value = "/unBound")
    public Result<?> unBound(@RequestBody InfoSourceGroupPage infoSourceGroupPage) {
        infoSourceMainGroupService.unBind(infoSourceGroupPage.getId(), infoSourceGroupPage.getInfoSourceIds());
        return Result.OK("解绑成功!");
    }


    /**
     * 查询信息源列表
     */
    @ApiOperation(value = "信息源信息源组关联表-绑定", notes = "信息源信息源组关联表-绑定")
    @GetMapping(value = "/infosourceMainList")
    public Result<?> infosourceMainList(InfoSourceMain infoSourceMain,
                                        @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                        @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        IPage<InfoSourceMain> pageList = infoSourceMainGroupService.infosourceMainList(infoSourceMain, pageNo, pageSize);
        return Result.OK(pageList);
    }



    /**
     * 批量绑定模板下载
     *
     * @author lkg
     * @date 2025/01/20
     */
    @GetMapping("/downloadTemplate")
    public void downloadTemplate(HttpServletResponse response) {
        String filePath = "bindInfoSource/绑定信息源模板main.xlsx";
        download(filePath, response);
    }

    public void download(String filePath, HttpServletResponse response) {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        byte[] bytes = obsUtil.getObjectByte(filePath);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try {
            OutputStream outs = response.getOutputStream();
            bos = new BufferedOutputStream(outs);
            bis = new BufferedInputStream(inputStream);
            int i;
            while ((i = bis.read(bytes)) != -1) {
                bos.write(bytes, 0, i);
            }
            bos.flush();
            bos.close();
            bis.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                bos.flush();
                bos.close();
                bis.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
    /**
     * 批量绑定信息源
     *
     * @author lkg
     * @date 2025/01/20
     */
    @PostMapping("/bindByFile")
    public Result<?> bindByFile(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        if (fileMap.size() < 1) {
            return Result.FAIL(500, "请上传excel文件");
        }
        String groupId = request.getParameter("groupId");
        if (StringUtils.isEmpty(groupId)) {
            return Result.FAIL(500, "请选择信息源组");
        }
        MultipartFile multipartFile = fileMap.get(new ArrayList<>(fileMap.keySet()).get(0));
        int index = multipartFile.getOriginalFilename().lastIndexOf(".");
        String fileSuffix = multipartFile.getOriginalFilename().substring(index + 1);
        if ("xls".equals(fileSuffix) || "xlsx".equals(fileSuffix)) {
            CompletableFuture.runAsync(()->{
                try {
                    //读取文件内容
                    List<List<String>> lists = ExcelExportUtil.readExcel(multipartFile.getInputStream(), 1, 4);
                    if (CollectionUtil.isNotEmpty(lists)) {
                        List<InfoSourceMainGroupMap> dataList = new ArrayList<>();
                        for (List<String> list : lists) {
                            String sourceId = list.get(0);
                            if(StringUtils.isEmpty(sourceId)){
                                //忽略空数据
                                continue;
                            }
                            InfoSourceMainGroupMap infoSourceGroupMap = new InfoSourceMainGroupMap();
                            infoSourceGroupMap.setGroupId(groupId);
                            infoSourceGroupMap.setSourceId(sourceId);
                            LambdaQueryWrapper<InfoSourceMainGroupMap> queryWrapper = Wrappers.lambdaQuery();
                            queryWrapper.eq(InfoSourceMainGroupMap::getGroupId, groupId).eq(InfoSourceMainGroupMap::getSourceId, sourceId);
                            int count = infoSourceMainGroupMapService.count(queryWrapper);
                            if (count == 0) {
                                dataList.add(infoSourceGroupMap);
                            }
                        }
                        infoSourceMainGroupMapService.saveBatch(dataList);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
            return Result.OK("正在导入中,请稍后查看...");
        } else {
            return Result.FAIL(500, "请上传excel文件");
        }
    }
}
