package com.zzsn.event.xxljob.service;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.event.entity.Event;
import com.zzsn.event.vo.AddEventParam;
import com.zzsn.event.vo.KeyWordsDTO;
import com.zzsn.event.xxljob.entity.XxlJobInfo;


import java.util.List;

/**
 * @Description: xxl_job_info
 * @Author: jeecg-boot
 * @Date: 2021-06-09
 * @Version: V1.0
 */
@DS("multi-datasource1")
public interface IXxlJobInfoService extends IService<XxlJobInfo> {

    /**关键词增加任务*/
    void keyWordsInsert(KeyWordsDTO keyWordsDTO);

    /**关键词删除任务*/
    void keyWordsUpdate(List<String> keyWordsCodes, String status);

    /**cron更新*/
    void cronUpdate(String code, String cron);

    /**关键词更改任务*/
    void keyWordsDelete(KeyWordsDTO keyWordsDTO);

    /**专题新增任务*/
    void subjectInsert(Event event);

    /**专题删除任务*/
    void subjectUpdate(List<String> subjectCodes, String status);

    /**专题更改任务*/
    void subjectDelete(Event event);
    void deleteByInfosourceCode(String infosourceCode);

}
