package com.zzsn.event.vo;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 专题关键词关联表
 * @Author: jeecg-boot
 * @Date:   2021-12-09
 * @Version: V1.0
 */
@Data
@TableName("subject_keywords_map")
@ApiModel(value="subject_keywords_map对象", description="专题关键词关联表")
public class SubjectKeywordsMap implements Serializable {
    private static final long serialVersionUID = 1L;

	/**主键*/
    @ApiModelProperty(value = "主键")
    private String id;
	/**专题id*/
	@Excel(name = "专题id", width = 15)
    @ApiModelProperty(value = "专题id")
    private String subjectId;
	/**关键词组id*/
	@Excel(name = "关键词组id", width = 15)
    @ApiModelProperty(value = "关键词组id")
    private String keywordsId;
    /**类别( 1：标题  2：正文  3：全文)*/
    private String type;
    /**绑定类型1：绑定为采集词，2：绑定为过滤词，3绑定为排除词组*/
    private String bindingType;
    /**是否启用元搜索 1启用，0不启用*/
    private Integer metaSearchFlag;
    /**需要命中的关键词的笛卡尔积数量*/
    //字段为空时，也更新数据库
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer cartesianNum;

}
