package com.zzsn.event.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.event.entity.SubjectType;
import com.zzsn.event.mapper.SubjectTypeMapper;
import com.zzsn.event.service.ISubjectTypeService;
import com.zzsn.event.util.tree.Node;
import com.zzsn.event.util.tree.TreeUtil;
import com.zzsn.event.vo.SubjectTreeVO;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 *
 *
 * @author lkg
 * @date 2024/4/28
 */
@Service
public class SubjectTypeServiceImpl extends ServiceImpl<SubjectTypeMapper, SubjectType> implements ISubjectTypeService {

    @Override
    public List<Node> enableList(String userId,String customerId) {
        return baseMapper.enableList(userId,customerId);
    }

    @Override
    public List<String> belowIdList(String typeId,String userId,String customerId) {
        List<Node> nodes = this.enableList(userId,customerId);
        return TreeUtil.belowList(nodes, typeId, true);
    }

    @Override
    public void add(SubjectType subjectType) {
        if (StringUtils.isEmpty(subjectType.getPid())) {
            subjectType.setPid("0");
        } else {
            //如果当前节点父ID不为空 则设置父节点的hasChildren 为1
            SubjectType parent = baseMapper.selectById(subjectType.getPid());
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                baseMapper.updateById(parent);
            }
        }
        subjectType.setCreateTime(new Date());
        baseMapper.insert(subjectType);
    }

    @Override
    public void edit(SubjectType subjectType) {
        SubjectType entity = this.getById(subjectType.getId());
        String old_pid = entity.getPid();
        String new_pid = subjectType.getPid();
        if (!old_pid.equals(new_pid)) {
            updateOldParentNode(old_pid);
            if (StringUtils.isEmpty(new_pid)) {
                subjectType.setPid("0");
            }
            if (!"0".equals(subjectType.getPid())) {
                baseMapper.updateTreeNodeStatus(subjectType.getPid(), 0);
            }
        }
        baseMapper.updateById(subjectType);
    }

    @Override
    @Transactional
    public void delete(String typeId) {
        SubjectType byId = getById(typeId);
        String pid = byId.getPid();
        baseMapper.deleteById(typeId);
        LambdaQueryWrapper<SubjectType> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SubjectType::getPid,pid);
        Integer count = baseMapper.selectCount(queryWrapper);
        if (count == 0) {
            baseMapper.updateTreeNodeStatus(pid,0);
        }
    }

    @Override
    public List<SubjectTreeVO> subjectAndTypeTree(String userId, String customerId) {
        List<SubjectTreeVO> subjectTreeVOS = baseMapper.subjectAndTypeTree(userId, customerId);
        List<SubjectTreeVO> tree = TreeUtil.tree(subjectTreeVOS, "0");
        tree.forEach(this::subjectNumCount);
        tree.sort(Comparator.comparing(SubjectTreeVO::getCreateTime));
        return tree;
    }

    @Override
    public List<SubjectTreeVO> subjectAndCustomerTree(String userId,String customerId) {
        List<SubjectTreeVO> subjectTreeVOS = baseMapper.enableCustomerList(customerId);
        List<SubjectTreeVO> list = baseMapper.subjectAndCustomerTree(userId,customerId);
        subjectTreeVOS.addAll(list);
        List<SubjectTreeVO> tree = TreeUtil.tree(subjectTreeVOS, "0");
        tree.forEach(this::subjectNumCount);
        return tree;
    }

    private void subjectNumCount(SubjectTreeVO subjectTreeVO) {
        Boolean ynSubject = subjectTreeVO.getYnSubject();
        if (!ynSubject) {
            int num = 0;
            List<? extends Node> children = subjectTreeVO.getChildren();
            if (CollectionUtils.isNotEmpty(children)) {
                for (Node node : children) {
                    SubjectTreeVO subjectTreeNode = (SubjectTreeVO)node;
                    subjectNumCount(subjectTreeNode);
                    num = num + 1;
                }
                subjectTreeVO.setSubjectCount(num);
            }
        }
    }

    private void updateOldParentNode(String pid) {
        if (!"0".equals(pid)) {
            Integer count = baseMapper.selectCount(new QueryWrapper<SubjectType>().eq("pid", pid));
            if (count == null || count <= 1) {
                baseMapper.updateTreeNodeStatus(pid, 0);
            }
        }
    }
}
