package com.zzsn.event.service;



import com.zzsn.event.entity.SubjectAnalysis;
import com.zzsn.event.vo.PropagationPathVo;
import com.zzsn.event.vo.StatisticAnalysisVo;
import com.zzsn.event.vo.ViewPointAnalysisVo;

import java.util.List;
import java.util.Map;

/**
 * @author lkg
 * @description: 专题分析
 * @date 2022/7/20 11:25
 */
public interface AnalysisService {

//    /**
//     * 观点分析
//     * @param subjectId 专题id
//     * @return java.util.Map<java.lang.String,java.util.List<com.zzsn.subjectAnalysis.vo.ViewPointAnalysisVo>>
//     */
//    Map<String, List<ViewPointAnalysisVo>> viewPointAnalysis(String subjectId);
//
    /**
     * 事件脉络
     * @param subjectId 专题id
     * @param fakeNum 专题事件脉络展示 伪事件脉络 的资讯数量阈值
     * @return java.util.List<com.zzsn.subjectAnalysis.entity.SubjectAnalysis>
     */
    List<SubjectAnalysis> eventContext(String subjectId, int fakeNum);

    /**
     * 传播路径
     * @param subjectId 专题id
     * @return com.zzsn.subjectAnalysis.vo.PropagationPathVo
     */
    PropagationPathVo propagationPath(String subjectId);


//    /**
//     * 统计分析-所有
//     * @param subjectId 专题id
//     * @return java.util.Map<java.lang.String,java.lang.Object>
//     */
//    Map<String, Object> statisticAnalysis(String subjectId);
//
//    /**
//     * 统计分析-按时间范围
//     * @param subjectId 专题id
//     * @param startTime 开始时间
//     * @param endTime 结束时间
//     */
//    List<StatisticAnalysisVo> statisticAnalysis(String subjectId, String startTime, String endTime);
}
