package com.zzsn.event.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @author : wp
 * @title : Subject
 * @description: 专题
 * @date : Created in 2022/7/7 10:04
 * @modified By:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@TableName(value = "subject",autoResultMap = true)
public class Subject implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @TableId(type = IdType.ASSIGN_ID)
    private String id;

    private String subjectCode;
    /**
     * 专题名称
     */
    private String subjectName;
    /**
     * 专题图片名称
     */
    private String picturePolicy;
    /**
     * 启用时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeEnable;
    /**
     * 停用时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date timeDisable;

    /**
     * 专题增量分析规则
     */
    private Integer increAnaRule;
    /**
     * 专题总量分析规则
     */
    private Integer totalAnaRule;
    /**
     * 专题时间间隔分析规则
     */
    private Integer timeAnaRule;
    /**
     * 专题最近一次分析时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date analysisTime;
    /**
     * 分析事件脉络-最新资讯的时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date eventTime;
    /**
     * 外事办映射id
     */
    private Integer wsbMapId;
    /**
     * 创建人
     */
    private String createBy;
    /**
     * 创建日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新日期
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
    /**
     * 所属部门
     */
    private String sysOrgCode;
    /**
     * 所属客户
     */
    private String customerId;
    private Integer status;

    /**
     * 专题类别（1：通用专题  2：事件专题）
     */
    public Integer subjectType;


}
